/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.storagereporter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.mill.db.repo.JpaSpaceStatsRepo;
import org.duracloud.mill.notification.NotificationManager;
import org.duracloud.mill.storagereporter.AccountStorageReportResult;
import org.duracloud.mill.storagereporter.StorageProviderResult;
import org.duracloud.mill.storagereporter.StorageReportResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageReporter.class);
    private JpaSpaceStatsRepo statsRepo;
    private DuracloudAccountRepo accountRepo;
    private NotificationManager notification;
    private static final BigDecimal TB_BIG_DECIMAL = new BigDecimal(1000000000000L);
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100);

    public StorageReporter(JpaSpaceStatsRepo statsRepo, DuracloudAccountRepo accountRepo, NotificationManager notification) {
        this.statsRepo = statsRepo;
        this.accountRepo = accountRepo;
        this.notification = notification;
    }

    public StorageReportResult run() {
        LinkedList<AccountStorageReportResult> oversubscribedAccounts = new LinkedList<AccountStorageReportResult>();
        LinkedList<AccountStorageReportResult> undersubscribedAccounts = new LinkedList<AccountStorageReportResult>();
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        Date lastMonth = c.getTime();
        List<AccountInfo> accounts = this.accountRepo.findByStatus(AccountInfo.AccountStatus.ACTIVE);
        Collections.sort(accounts, new Comparator<AccountInfo>(){

            @Override
            public int compare(AccountInfo o1, AccountInfo o2) {
                return o1.getAcctName().compareTo(o2.getAcctName());
            }
        });
        for (AccountInfo account : accounts) {
            String accountId = account.getSubdomain();
            LOGGER.info("processing {}", (Object)accountId);
            StorageProviderAccount primary = account.getPrimaryStorageProviderAccount();
            Set<StorageProviderAccount> secondary = account.getSecondaryStorageProviderAccounts();
            LinkedList<StorageProviderAccount> providers = new LinkedList<StorageProviderAccount>(secondary);
            providers.add(0, primary);
            AccountStorageReportResult result = new AccountStorageReportResult(account);
            for (StorageProviderAccount storageProviderAccount : providers) {
                List<Object[]> stats = this.statsRepo.getByAccountIdAndStoreId(accountId, String.valueOf(storageProviderAccount.getId()), lastMonth, now, "%Y-%m-%d");
                long total = 0L;
                if (stats != null && stats.size() > 0) {
                    total = ((BigDecimal)stats.get(stats.size() - 1)[3]).longValue();
                }
                result.addStorageProviderResult(storageProviderAccount, total);
            }
            if (result.isOversubscribed()) {
                oversubscribedAccounts.add(result);
                continue;
            }
            undersubscribedAccounts.add(result);
        }
        String subject = MessageFormat.format("DuraCloud Storage Report: {0} accounts over subscription limit", oversubscribedAccounts.size());
        StringBuilder body = new StringBuilder();
        if (oversubscribedAccounts.size() == 0) {
            body.append("Presently there are no accounts over their subscription limits.\n\n");
        } else {
            body.append("Accounts OVER their subscribed storage limit: \n\n");
        }
        for (AccountStorageReportResult result : oversubscribedAccounts) {
            this.appendResultToBody(result, body);
        }
        body.append("\nAccounts UNDER their subscribed storage limit: \n\n");
        for (AccountStorageReportResult result : undersubscribedAccounts) {
            this.appendResultToBody(result, body);
        }
        LOGGER.info("sending notification...");
        this.notification.sendEmail(subject, body.toString());
        LOGGER.info("Report complete: {} accounts over limit,  {} accounts under limit.", (Object)oversubscribedAccounts.size(), (Object)undersubscribedAccounts.size());
        return new StorageReportResult(oversubscribedAccounts, undersubscribedAccounts);
    }

    private void appendResultToBody(AccountStorageReportResult result, StringBuilder body) {
        AccountInfo account = result.getAccount();
        body.append(MessageFormat.format("{0} (subdomain={1}):\n", account.getAcctName(), account.getSubdomain()));
        for (StorageProviderResult presult : result.getStorageProviderResults()) {
            StorageProviderAccount spa = presult.getStorageProviderAccount();
            int limit = spa.getStorageLimit();
            String total = new BigDecimal(presult.getTotalBytes()).divide(TB_BIG_DECIMAL, 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP).toString();
            String capacity = new BigDecimal(presult.getTotalBytes()).divide(new BigDecimal((long)limit * 1000000000000L), 2, RoundingMode.HALF_UP).multiply(ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP).toString();
            String line = MessageFormat.format("    provider={0}/{1}, current total: {2} TB, allocated storage: {3} TB, capacity: {4} %, status: {5}\n", String.valueOf(spa.getId()), spa.getProviderType().name(), total, limit, capacity, presult.isOversubscribed() ? "OVER LIMIT" : "OK");
            body.append(line);
        }
        body.append("\n");
    }
}

