/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertyLoader {
    private static Logger log = LoggerFactory.getLogger(SystemPropertyLoader.class);

    private SystemPropertyLoader() {
    }

    public static void load(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Config file " + filePath + " not found.");
        }
        log.info("loading {}", (Object)file);
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(file);){
            props.load(is);
            for (Object key : props.keySet()) {
                if (System.getProperty(key.toString()) != null) continue;
                System.setProperty(key.toString(), props.get(key).toString());
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to load configuration file: " + file, e);
        }
        log.info("successfully loaded {}", (Object)file);
    }
}

