/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

public class CacheValue<T> {
    private static final CacheValue<?> ABSENT = new CacheValue<Object>(null);
    private final T value;

    private CacheValue(T type) {
        this.value = type;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean hasValue(T value) {
        return this.isPresent() ? this.value.equals(value) : value == null;
    }

    public static <T> CacheValue<T> ofNullable(T value) {
        return value == null ? ABSENT : new CacheValue<T>(value);
    }

    public int hashCode() {
        return this.isPresent() ? 0 : this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheValue)) {
            return false;
        }
        CacheValue that = (CacheValue)obj;
        return this.value == null ? false : this.value.equals(that.value);
    }
}

