/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.db.repo;

import java.util.Date;
import java.util.List;
import org.duracloud.mill.db.model.SpaceStats;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="spaceStatsRepo")
public interface JpaSpaceStatsRepo
extends JpaRepository<SpaceStats, Long> {
    public static final String INTERVAL_DAY = "%Y-%m-%d";
    public static final String INTERVAL_WEEK = "%Y-%u";
    public static final String INTERVAL_MONTH = "%Y-%m";

    @Query(nativeQuery=true, value="select    unix_timestamp(date_format(min(modified), '%Y-%m-%d 23:59:59')) as modified,     account_id,    store_id,    space_id,    avg(byte_count) as byte_count,    avg(object_count) as object_count,    date_format(modified, :interval) from space_stats  where  account_id = :accountId and      store_id = :storeId and      space_id = :spaceId and      modified between :start and :end group by   date_format(modified, :interval),            account_id,            store_id,             space_id")
    public List<Object[]> getByAccountIdAndStoreIdAndSpaceId(@Param(value="accountId") String var1, @Param(value="storeId") String var2, @Param(value="spaceId") String var3, @Param(value="start") Date var4, @Param(value="end") Date var5, @Param(value="interval") String var6);

    @Query(nativeQuery=true, value="select a.modified, a.account_id, a.store_id, sum(a.byte_count), sum(a.object_count) from (select    unix_timestamp(date_format(min(modified), '%Y-%m-%d 23:59:59')) as modified,     account_id,    store_id,    space_id,    avg(byte_count) as byte_count,    avg(object_count) as object_count,    date_format(modified, :interval) from space_stats  where  account_id = :accountId and      store_id = :storeId and      modified between :start and :end group by   date_format(modified, :interval),            account_id,            store_id,             space_id) a group by a.modified, a.account_id, a.store_id")
    public List<Object[]> getByAccountIdAndStoreId(@Param(value="accountId") String var1, @Param(value="storeId") String var2, @Param(value="start") Date var3, @Param(value="end") Date var4, @Param(value="interval") String var5);

    @Query(nativeQuery=true, value="select    unix_timestamp(date_format(min(modified), '%Y-%m-%d 23:59:59')) as modified,     account_id,    store_id,    space_id,    avg(byte_count) as byte_count,    avg(object_count) as object_count,    date_format(modified, '%Y-%m-%d 00:00:00') from space_stats  where  account_id = :accountId and      store_id = :storeId and      modified between :start and :end group by   date_format(modified, '%Y-%m-%d'),            account_id,            store_id,             space_id")
    public List<Object[]> getByAccountIdAndStoreIdAndDay(@Param(value="accountId") String var1, @Param(value="storeId") String var2, @Param(value="start") Date var3, @Param(value="end") Date var4);
}

