/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.util.ClassUtils;

public class BeanDefinitionUtils {
    private static final String JNDI_OBJECT_FACTORY_BEAN = "org.springframework.jndi.JndiObjectFactoryBean";
    private static final List<Class<?>> EMF_TYPES;

    public static Iterable<String> getEntityManagerFactoryBeanNames(ListableBeanFactory beanFactory) {
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, EntityManagerFactory.class, true, false);
        HashSet<String> names = new HashSet<String>(Arrays.asList(beanNames));
        for (String factoryBeanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, AbstractEntityManagerFactoryBean.class, true, false)) {
            names.add(BeanFactoryUtils.transformedBeanName(factoryBeanName));
        }
        return names;
    }

    public static Collection<EntityManagerFactoryBeanDefinition> getEntityManagerFactoryBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        HashSet<EntityManagerFactoryBeanDefinition> definitions = new HashSet<EntityManagerFactoryBeanDefinition>();
        for (Class<?> type : EMF_TYPES) {
            for (String name : beanFactory.getBeanNamesForType(type, true, false)) {
                BeanDefinitionUtils.registerEntityManagerFactoryBeanDefinition(BeanFactoryUtils.transformedBeanName(name), beanFactory, definitions);
            }
        }
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
            definitions.addAll(BeanDefinitionUtils.getEntityManagerFactoryBeanDefinitions((ConfigurableListableBeanFactory)parentBeanFactory));
        }
        return definitions;
    }

    private static void registerEntityManagerFactoryBeanDefinition(String name, ConfigurableListableBeanFactory beanFactory, Collection<EntityManagerFactoryBeanDefinition> definitions) {
        BeanDefinition definition = beanFactory.getBeanDefinition(name);
        if (JNDI_OBJECT_FACTORY_BEAN.equals(definition.getBeanClassName()) ? !EntityManagerFactory.class.getName().equals(definition.getPropertyValues().get("expectedType")) : beanFactory.getType(name) == null || !EntityManagerFactory.class.isAssignableFrom(beanFactory.getType(name))) {
            return;
        }
        definitions.add(new EntityManagerFactoryBeanDefinition(name, beanFactory));
    }

    public static BeanDefinition getBeanDefinition(String name, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(name);
        }
        catch (NoSuchBeanDefinitionException o_O) {
            BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
            if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                return BeanDefinitionUtils.getBeanDefinition(name, (ConfigurableListableBeanFactory)parentBeanFactory);
            }
            throw o_O;
        }
    }

    static {
        ArrayList<Class<JndiObjectFactoryBean>> types = new ArrayList<Class<JndiObjectFactoryBean>>();
        types.add(EntityManagerFactory.class);
        types.add(AbstractEntityManagerFactoryBean.class);
        if (ClassUtils.isPresent(JNDI_OBJECT_FACTORY_BEAN, ClassUtils.getDefaultClassLoader())) {
            types.add(JndiObjectFactoryBean.class);
        }
        EMF_TYPES = Collections.unmodifiableList(types);
    }

    public static class EntityManagerFactoryBeanDefinition {
        private final String beanName;
        private final ConfigurableListableBeanFactory beanFactory;

        public EntityManagerFactoryBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
            this.beanName = beanName;
            this.beanFactory = beanFactory;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public BeanFactory getBeanFactory() {
            return this.beanFactory;
        }

        public BeanDefinition getBeanDefinition() {
            return this.beanFactory.getBeanDefinition(this.beanName);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityManagerFactoryBeanDefinition)) {
                return false;
            }
            EntityManagerFactoryBeanDefinition other = (EntityManagerFactoryBeanDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$beanName = this.getBeanName();
            String other$beanName = other.getBeanName();
            if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
                return false;
            }
            BeanFactory this$beanFactory = this.getBeanFactory();
            BeanFactory other$beanFactory = other.getBeanFactory();
            return !(this$beanFactory == null ? other$beanFactory != null : !this$beanFactory.equals(other$beanFactory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntityManagerFactoryBeanDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $beanName = this.getBeanName();
            result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
            BeanFactory $beanFactory = this.getBeanFactory();
            result = result * 59 + ($beanFactory == null ? 43 : $beanFactory.hashCode());
            return result;
        }
    }
}

