/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class SystemPropertiesReader {
    private Logger log = LoggerFactory.getLogger(SystemPropertiesReader.class);

    public SystemPropertiesReader(Collection<Resource> resources) {
        Properties systemProperties = System.getProperties();
        for (Resource resource : resources) {
            try {
                InputStream inputStream = resource.getInputStream();
                try {
                    systemProperties.load(inputStream);
                    this.log.info("loaded {}", (Object)resource.getFile().getAbsolutePath());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception ex) {
                try {
                    this.log.warn("unable to load resource: {}", (Object)resource.getFile().getAbsolutePath());
                }
                catch (Exception e) {
                    this.log.error("unable to load resource: {}", (Object)e.getMessage());
                }
            }
        }
    }
}

