/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.storagereporter;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.common.model.EmailerType;
import org.duracloud.mill.config.ConfigurationManager;
import org.duracloud.mill.db.repo.JpaSpaceStatsRepo;
import org.duracloud.mill.notification.NotificationManager;
import org.duracloud.mill.notification.SESNotificationManager;
import org.duracloud.mill.notification.SMTPNotificationManager;
import org.duracloud.mill.storagereporter.StorageReporter;
import org.duracloud.mill.util.CommonCommandLineOptions;
import org.duracloud.mill.util.DriverSupport;
import org.duracloud.mill.util.PropertyDefinition;
import org.duracloud.mill.util.PropertyDefinitionListBuilder;
import org.duracloud.mill.util.PropertyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class AppDriver
extends DriverSupport {
    public static Logger log = LoggerFactory.getLogger(AppDriver.class);

    public AppDriver() {
        super(new CommonCommandLineOptions());
    }

    public static void main(String[] args) {
        log.debug(String.valueOf(args));
        new AppDriver().execute(args);
    }

    @Override
    protected void executeImpl(CommandLine commandLine) {
        List<PropertyDefinition> defintions = new PropertyDefinitionListBuilder().addAws().addNotificationConfig().addNotifications().addNotificationsNonTech().addMcDb().addMillDb().build();
        PropertyVerifier verifier = new PropertyVerifier(defintions);
        verifier.verify(System.getProperties());
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext("org.duracloud.mill.db", "org.duracloud.account.db");
        JpaSpaceStatsRepo statsRepo = context.getBean(JpaSpaceStatsRepo.class);
        DuracloudAccountRepo accountRepo = context.getBean(DuracloudAccountRepo.class);
        ConfigurationManager configManager = new ConfigurationManager();
        LinkedList<String> recipients = new LinkedList<String>();
        recipients.addAll(Arrays.asList(configManager.getNotificationRecipients()));
        recipients.addAll(Arrays.asList(configManager.getNotificationRecipientsNonTech()));
        NotificationManager notification = null;
        notification = configManager.getEmailerType() == EmailerType.SMTP ? new SMTPNotificationManager(configManager.getNotificationRecipients(), configManager) : new SESNotificationManager(recipients.toArray(new String[0]));
        StorageReporter reporter = new StorageReporter(statsRepo, accountRepo, notification);
        reporter.run();
        context.close();
    }
}

