/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.QueryHint;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.support.QueryHints;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractJpaQuery
implements RepositoryQuery {
    private final JpaQueryMethod method;
    private final EntityManager em;
    private final JpaMetamodel metamodel;
    private final PersistenceProvider provider;
    private final Lazy<JpaQueryExecution> execution;
    final Lazy<ParameterBinder> parameterBinder = Lazy.of(this::createBinder);

    public AbstractJpaQuery(JpaQueryMethod method, EntityManager em) {
        Assert.notNull((Object)method, "JpaQueryMethod must not be null!");
        Assert.notNull((Object)em, "EntityManager must not be null!");
        this.method = method;
        this.em = em;
        this.metamodel = JpaMetamodel.of(em.getMetamodel());
        this.provider = PersistenceProvider.fromEntityManager(em);
        this.execution = Lazy.of(() -> {
            if (method.isStreamQuery()) {
                return new JpaQueryExecution.StreamExecution();
            }
            if (method.isProcedureQuery()) {
                return new JpaQueryExecution.ProcedureExecution(method.isCollectionQuery());
            }
            if (method.isCollectionQuery()) {
                return new JpaQueryExecution.CollectionExecution();
            }
            if (method.isSliceQuery()) {
                return new JpaQueryExecution.SlicedExecution();
            }
            if (method.isPageQuery()) {
                return new JpaQueryExecution.PagedExecution();
            }
            if (method.isModifyingQuery()) {
                return null;
            }
            return new JpaQueryExecution.SingleEntityExecution();
        });
    }

    @Override
    public JpaQueryMethod getQueryMethod() {
        return this.method;
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    protected JpaMetamodel getMetamodel() {
        return this.metamodel;
    }

    @Override
    @Nullable
    public Object execute(Object[] parameters) {
        return this.doExecute(this.getExecution(), parameters);
    }

    @Nullable
    private Object doExecute(JpaQueryExecution execution, Object[] values) {
        JpaParametersParameterAccessor accessor = this.obtainParameterAccessor(values);
        Object result = execution.execute(this, accessor);
        ResultProcessor withDynamicProjection = this.method.getResultProcessor().withDynamicProjection(accessor);
        return withDynamicProjection.processResult(result, new TupleConverter(withDynamicProjection.getReturnedType()));
    }

    private JpaParametersParameterAccessor obtainParameterAccessor(Object[] values) {
        return this.provider.getParameterAccessor(this.method.getParameters(), values, this.em);
    }

    protected JpaQueryExecution getExecution() {
        JpaQueryExecution execution = this.execution.getNullable();
        if (execution != null) {
            return execution;
        }
        if (this.method.isModifyingQuery()) {
            return new JpaQueryExecution.ModifyingExecution(this.method, this.em);
        }
        return new JpaQueryExecution.SingleEntityExecution();
    }

    protected <T extends Query> T applyHints(T query2, JpaQueryMethod method) {
        List<QueryHint> hints = method.getHints();
        if (!hints.isEmpty()) {
            for (QueryHint hint : hints) {
                this.applyQueryHint(query2, hint);
            }
        }
        return query2;
    }

    protected <T extends Query> void applyQueryHint(T query2, QueryHint hint) {
        Assert.notNull(query2, "Query must not be null!");
        Assert.notNull((Object)hint, "QueryHint must not be null!");
        query2.setHint(hint.name(), hint.value());
    }

    private Query applyLockMode(Query query2, JpaQueryMethod method) {
        LockModeType lockModeType = method.getLockModeType();
        return lockModeType == null ? query2 : query2.setLockMode(lockModeType);
    }

    protected ParameterBinder createBinder() {
        return ParameterBinderFactory.createBinder(this.getQueryMethod().getParameters());
    }

    protected Query createQuery(JpaParametersParameterAccessor parameters) {
        return this.applyLockMode(this.applyEntityGraphConfiguration(this.applyHints(this.doCreateQuery(parameters), this.method), this.method), this.method);
    }

    private Query applyEntityGraphConfiguration(Query query2, JpaQueryMethod method) {
        JpaEntityGraph entityGraph = method.getEntityGraph();
        if (entityGraph != null) {
            QueryHints hints = Jpa21Utils.getFetchGraphHint(this.em, method.getEntityGraph(), this.getQueryMethod().getEntityInformation().getJavaType());
            hints.forEach(query2::setHint);
        }
        return query2;
    }

    protected Query createCountQuery(JpaParametersParameterAccessor values) {
        Query countQuery = this.doCreateCountQuery(values);
        return this.method.applyHintsToCountQuery() ? this.applyHints(countQuery, this.method) : countQuery;
    }

    @Nullable
    protected Class<?> getTypeToRead(ReturnedType returnedType) {
        if (PersistenceProvider.ECLIPSELINK.equals(this.provider)) {
            return null;
        }
        return returnedType.isProjecting() && !this.getMetamodel().isJpaManaged(returnedType.getReturnedType()) ? Tuple.class : null;
    }

    protected abstract Query doCreateQuery(JpaParametersParameterAccessor var1);

    protected abstract Query doCreateCountQuery(JpaParametersParameterAccessor var1);

    static class TupleConverter
    implements Converter<Object, Object> {
        private final ReturnedType type;

        public TupleConverter(ReturnedType type) {
            Assert.notNull((Object)type, "Returned type must not be null!");
            this.type = type;
        }

        @Override
        public Object convert(Object source) {
            Object value;
            if (!(source instanceof Tuple)) {
                return source;
            }
            Tuple tuple = (Tuple)source;
            List<TupleElement<?>> elements = tuple.getElements();
            if (elements.size() == 1 && (this.type.isInstance(value = tuple.get(elements.get(0))) || value == null)) {
                return value;
            }
            return new TupleBackedMap(tuple);
        }

        private static class TupleBackedMap
        implements Map<String, Object> {
            private static final String UNMODIFIABLE_MESSAGE = "A TupleBackedMap cannot be modified.";
            private final Tuple tuple;

            TupleBackedMap(Tuple tuple) {
                this.tuple = tuple;
            }

            @Override
            public int size() {
                return this.tuple.getElements().size();
            }

            @Override
            public boolean isEmpty() {
                return this.tuple.getElements().isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                try {
                    this.tuple.get((String)key);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            @Override
            public boolean containsValue(Object value) {
                return Arrays.asList(this.tuple.toArray()).contains(value);
            }

            @Override
            @Nullable
            public Object get(Object key) {
                if (!(key instanceof String)) {
                    return null;
                }
                try {
                    return this.tuple.get((String)key);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }

            @Override
            public Object put(String key, Object value) {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public void putAll(Map<? extends String, ?> m) {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public Set<String> keySet() {
                return this.tuple.getElements().stream().map(TupleElement::getAlias).collect(Collectors.toSet());
            }

            @Override
            public Collection<Object> values() {
                return Arrays.asList(this.tuple.toArray());
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return this.tuple.getElements().stream().map(e -> new AbstractMap.SimpleEntry(e.getAlias(), this.tuple.get(e))).collect(Collectors.toSet());
            }
        }
    }
}

