/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.duracloud.mill.util.PropertyDefinition;

public class PropertyDefinitionListBuilder {
    private List<PropertyDefinition> definitions = new LinkedList<PropertyDefinition>();

    public PropertyDefinitionListBuilder addAws() {
        this.add("aws.accessKeyId", false);
        this.add("aws.secretKey", false, true);
        return this;
    }

    private void add(String name, boolean required, boolean sensitive) {
        this.definitions.add(new PropertyDefinition(name, null, required, sensitive));
    }

    private void add(String name, boolean required) {
        this.add(name, required, false);
    }

    public PropertyDefinitionListBuilder addMillDb() {
        this.add("mill.db.name", true);
        this.add("mill.db.host", true);
        this.add("mill.db.port", true);
        this.add("mill.db.user", true);
        this.add("mill.db.pass", true, true);
        return this;
    }

    public PropertyDefinitionListBuilder addMcDb() {
        this.add("db.name", true);
        this.add("db.host", true);
        this.add("db.port", true);
        this.add("db.user", true);
        this.add("db.pass", true, true);
        return this;
    }

    public PropertyDefinitionListBuilder addDeadLetterQueue() {
        this.add("queue.name.dead-letter", true);
        return this;
    }

    public PropertyDefinitionListBuilder addAuditQueue() {
        this.add("queue.name.audit", true);
        return this;
    }

    public PropertyDefinitionListBuilder addDuplicationHighPriorityQueue() {
        this.add("queue.name.dup-high-priority", true);
        return this;
    }

    public PropertyDefinitionListBuilder addDuplicationLowPriorityQueue() {
        this.add("queue.name.dup-low-priority", true);
        return this;
    }

    public PropertyDefinitionListBuilder addLocalDuplicationDir() {
        this.add("local-duplication-dir", false);
        return this;
    }

    public PropertyDefinitionListBuilder addDuplicationPolicyBucketSuffix() {
        this.add("duplication-policy.bucket-suffix", false);
        return this;
    }

    public PropertyDefinitionListBuilder addDuplicationPolicyRefreshFrequency() {
        this.add("duplication-policy.refresh-frequency", false);
        return this;
    }

    public PropertyDefinitionListBuilder addBitIntegrityQueue() {
        this.add("queue.name.bit-integrity", true);
        return this;
    }

    public PropertyDefinitionListBuilder addBitIntegrityErrorQueue() {
        this.add("queue.name.bit-error", true);
        return this;
    }

    public PropertyDefinitionListBuilder addNotificationRecipients() {
        this.add("notification.recipients", true);
        return this;
    }

    public PropertyDefinitionListBuilder addWorkDir() {
        this.add("workdir", true);
        return this;
    }

    public List<PropertyDefinition> build() {
        return new ArrayList<PropertyDefinition>(this.definitions);
    }

    public PropertyDefinitionListBuilder addMaxWorkers() {
        this.add("max-workers", false);
        return this;
    }

    public PropertyDefinitionListBuilder addDuracloudAuditSpace() {
        this.add("audit-log-generator.audit-log-space-id", true);
        return this;
    }

    public PropertyDefinitionListBuilder addLoopingBitFrequency() {
        this.add("looping.bit.frequency", false);
        return this;
    }

    public PropertyDefinitionListBuilder addLoopingBitMaxQueueSize() {
        this.add("looping.bit.max-task-queue-size", false);
        return this;
    }

    public PropertyDefinitionListBuilder addLoopingDupFrequency() {
        this.add("looping.dup.frequency", false);
        return this;
    }

    public PropertyDefinitionListBuilder addLoopingDupMaxQueueSize() {
        this.add("looping.dup.max-task-queue-size", false);
        return this;
    }

    public PropertyDefinitionListBuilder addManifestExpirationDate() {
        this.add("manifest.expiration-time", true);
        return this;
    }

    public PropertyDefinitionListBuilder addTaskQueueOrder() {
        this.add("queue.task.ordered", true);
        return this;
    }
}

