/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.metrics.MetricCollector;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.metrics.ServiceMetricCollector;
import com.amazonaws.metrics.internal.cloudwatch.CloudWatchMetricConfig;
import com.amazonaws.metrics.internal.cloudwatch.MetricUploaderThread;
import com.amazonaws.metrics.internal.cloudwatch.RequestMetricCollectorSupport;
import com.amazonaws.metrics.internal.cloudwatch.ServiceMetricCollectorSupport;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;

@ThreadSafe
public class MetricCollectorSupport
extends MetricCollector {
    protected static final Log log = LogFactory.getLog(MetricCollectorSupport.class);
    private static volatile MetricCollectorSupport singleton;
    private final RequestMetricCollectorSupport requestMetricCollector;
    private final ServiceMetricCollectorSupport serviceMetricCollector;
    private final BlockingQueue<MetricDatum> queue;
    private final CloudWatchMetricConfig config;
    private MetricUploaderThread uploaderThread;

    static MetricCollectorSupport getInstance() {
        return singleton;
    }

    static synchronized boolean startSingleton(CloudWatchMetricConfig config) {
        if (singleton != null) {
            return false;
        }
        log.info("Initializing " + MetricCollectorSupport.class.getSimpleName());
        return MetricCollectorSupport.createAndStartCollector(config);
    }

    static synchronized boolean restartSingleton(CloudWatchMetricConfig config) {
        if (singleton == null) {
            throw new IllegalStateException(MetricCollectorSupport.class.getSimpleName() + " has neven been initialized");
        }
        log.info("Re-initializing " + MetricCollectorSupport.class.getSimpleName());
        singleton.stop();
        return MetricCollectorSupport.createAndStartCollector(config);
    }

    private static boolean createAndStartCollector(CloudWatchMetricConfig config) {
        MetricCollectorSupport collector = new MetricCollectorSupport(config);
        if (collector.start()) {
            singleton = collector;
            return true;
        }
        return false;
    }

    protected MetricCollectorSupport(CloudWatchMetricConfig config) {
        if (config == null) {
            throw new IllegalArgumentException();
        }
        this.config = config;
        this.queue = new LinkedBlockingQueue<MetricDatum>(config.getMetricQueueSize());
        this.requestMetricCollector = new RequestMetricCollectorSupport(this.queue);
        this.serviceMetricCollector = new ServiceMetricCollectorSupport(this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Class<MetricCollectorSupport> clazz = MetricCollectorSupport.class;
        synchronized (MetricCollectorSupport.class) {
            if (this.uploaderThread != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            this.uploaderThread = new MetricUploaderThread(this.config, this.queue);
            this.uploaderThread.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Class<MetricCollectorSupport> clazz = MetricCollectorSupport.class;
        synchronized (MetricCollectorSupport.class) {
            if (this.uploaderThread != null) {
                this.uploaderThread.cancel();
                this.uploaderThread.interrupt();
                this.uploaderThread = null;
                if (singleton == this) {
                    singleton = null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    public CloudWatchMetricConfig getConfig() {
        return this.config;
    }

    public AmazonCloudWatchClient getCloudwatchClient() {
        return this.uploaderThread == null ? null : this.uploaderThread.getCloudwatchClient();
    }

    public final boolean isEnabled() {
        return true;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public ServiceMetricCollector getServiceMetricCollector() {
        return this.serviceMetricCollector;
    }
}

