/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.duracloud.mill.util.FileLineIterator;

public class Iterators {
    private static final CacheManager cacheManager = CacheManager.newInstance(Iterators.class.getResource("/ehcache.xml"));

    public static Iterator<String> difference(Iterator<String> iterA, Iterator<String> iterB) throws IOException {
        String cacheName = "compare-" + System.currentTimeMillis();
        cacheManager.addCache(cacheName);
        Cache cache = cacheManager.getCache(cacheName);
        while (iterB.hasNext()) {
            String item = iterB.next();
            cache.put(new Element((Serializable)((Object)item), null));
        }
        int diffCnt = 0;
        File diffFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "diff-" + System.currentTimeMillis() + ".txt");
        FileWriter fileWriter = new FileWriter(diffFile);
        while (iterA.hasNext()) {
            String item = iterA.next();
            if (cache.isKeyInCache(item)) continue;
            fileWriter.write(item + "\n");
            if (++diffCnt % 100 != 0) continue;
            fileWriter.flush();
        }
        fileWriter.close();
        cache.removeAll();
        cacheManager.removeCache(cache.getName());
        if (diffCnt > 0) {
            return new FileLineIterator(diffFile);
        }
        diffFile.delete();
        return new ArrayList(0).iterator();
    }
}

