/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.profile.internal.Profile;
import com.amazonaws.auth.profile.internal.ProfilesConfigFileParser;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilesConfigFile {
    private static final Log LOG = LogFactory.getLog(ProfilesConfigFile.class);
    private static final String CONFIG_FILE_ENVIRONMENT_VARIABLE = "AWS_CONFIG_FILE";
    public static final String DEFAULT_PROFILE_NAME = "default";
    private Map<String, Profile> profilesByName = new HashMap<String, Profile>();

    public ProfilesConfigFile() throws AmazonClientException {
        this(ProfilesConfigFile.getConfigFile());
    }

    public ProfilesConfigFile(String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file path is null.");
        }
        this.loadProfiles(new File(filePath));
    }

    public ProfilesConfigFile(File file) throws AmazonClientException {
        this.loadProfiles(file);
    }

    public AWSCredentials getCredentials(String profile) {
        if (this.profilesByName.get(profile) == null) {
            throw new IllegalArgumentException("No AWS profile named '" + profile + "'");
        }
        return this.profilesByName.get(profile).getCredentials();
    }

    private static File getConfigFile() {
        String configFileOverride = System.getenv(CONFIG_FILE_ENVIRONMENT_VARIABLE);
        if (configFileOverride != null) {
            LOG.debug("Loading AWS profile configuration from overridden file: " + configFileOverride);
            return new File(configFileOverride);
        }
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new AmazonClientException("Unable to load AWS profiles: 'user.home' System property is not set.");
        }
        File awsDirectory = new File(userHome, ".aws");
        return new File(awsDirectory, "config");
    }

    private void loadProfiles(File file) {
        this.profilesByName.putAll(ProfilesConfigFileParser.loadProfiles(file));
    }
}

