/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.primitives.Chars;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.http.filters.StripExpectHeader;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.MultipartForm;
import org.jclouds.io.payloads.Part;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.Binder;
import org.jclouds.rest.InputParamValidator;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.BuildVersion;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.OverrideRequestFilters;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.PartParam;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.binders.BindMapToStringPayload;
import org.jclouds.rest.binders.BindToJsonPayloadWrappedWith;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.GetAcceptHeaders;
import org.jclouds.util.Strings2;

public class RestAnnotationProcessor
implements Function<Invocation, HttpRequest> {
    @Resource
    protected Logger logger = Logger.NULL;
    private static final Function<? super Map.Entry<String, Object>, ? extends Part> ENTRY_TO_PART = new Function<Map.Entry<String, Object>, Part>(){

        @Override
        public Part apply(Map.Entry<String, Object> from) {
            return Part.create(from.getKey(), from.getValue().toString());
        }
    };
    private final Injector injector;
    private final HttpUtils utils;
    private final ContentMetadataCodec contentMetadataCodec;
    private final String apiVersion;
    private final String buildVersion;
    private final InputParamValidator inputParamValidator;
    private final GetAcceptHeaders getAcceptHeaders;
    private final Invocation caller;
    private final boolean stripExpectHeader;
    private static final TypeLiteral<Supplier<URI>> uriSupplierLiteral = new TypeLiteral<Supplier<URI>>(){};
    private static final LoadingCache<Invokable<?, ?>, Set<Integer>> invokableToIndexesOfOptions = CacheBuilder.newBuilder().build(new CacheLoader<Invokable<?, ?>, Set<Integer>>(){

        @Override
        public Set<Integer> load(Invokable<?, ?> invokable) {
            ImmutableSet.Builder toReturn = ImmutableSet.builder();
            for (Parameter param : Reflection2.getInvokableParameters(invokable)) {
                Class<?> type = param.getType().getRawType();
                if (!HttpRequestOptions.class.isAssignableFrom(type) && !HttpRequestOptions[].class.isAssignableFrom(type)) continue;
                toReturn.add((Object)param.hashCode());
            }
            return toReturn.build();
        }
    });

    @Inject
    private RestAnnotationProcessor(Injector injector, @ApiVersion String apiVersion, @BuildVersion String buildVersion, HttpUtils utils, ContentMetadataCodec contentMetadataCodec, InputParamValidator inputParamValidator, GetAcceptHeaders getAcceptHeaders, @Nullable @Named(value="caller") Invocation caller, @Named(value="jclouds.strip-expect-header") boolean stripExpectHeader) {
        this.injector = injector;
        this.utils = utils;
        this.contentMetadataCodec = contentMetadataCodec;
        this.apiVersion = apiVersion;
        this.buildVersion = buildVersion;
        this.inputParamValidator = inputParamValidator;
        this.getAcceptHeaders = getAcceptHeaders;
        this.caller = caller;
        this.stripExpectHeader = stripExpectHeader;
    }

    @Deprecated
    public GeneratedHttpRequest createRequest(Invokable<?, ?> invokable, List<Object> args) {
        return this.apply(Invocation.create(invokable, args));
    }

    @Override
    public GeneratedHttpRequest apply(Invocation invocation) {
        List<Part> parts;
        Multimap<String, String> headers;
        Multimap<String, Object> formParams;
        Preconditions.checkNotNull(invocation, "invocation");
        this.inputParamValidator.validateMethodParametersOrThrow(invocation, Reflection2.getInvokableParameters(invocation.getInvokable()));
        Optional<Object> endpoint = Optional.absent();
        HttpRequest r = RestAnnotationProcessor.findOrNull(invocation.getArgs(), HttpRequest.class);
        if (r != null) {
            endpoint = Optional.fromNullable(r.getEndpoint());
            if (endpoint.isPresent()) {
                this.logger.trace("using endpoint %s from invocation.getArgs() for %s", endpoint, invocation);
            }
        } else if (this.caller != null) {
            endpoint = this.getEndpointFor(this.caller);
            if (endpoint.isPresent()) {
                this.logger.trace("using endpoint %s from caller %s for %s", endpoint, this.caller, invocation);
            } else {
                endpoint = this.findEndpoint(invocation);
            }
        } else {
            endpoint = this.findEndpoint(invocation);
        }
        if (!endpoint.isPresent()) {
            throw new NoSuchElementException(String.format("no endpoint found for %s", invocation));
        }
        GeneratedHttpRequest.Builder requestBuilder = GeneratedHttpRequest.builder().invocation(invocation).caller(this.caller);
        String requestMethod = null;
        if (r != null) {
            requestMethod = r.getMethod();
            requestBuilder.fromHttpRequest(r);
        } else {
            requestMethod = HttpUtils.tryFindHttpMethod(invocation.getInvokable()).get();
            requestBuilder.method(requestMethod);
        }
        requestBuilder.filters(this.getFiltersIfAnnotated(invocation));
        if (this.stripExpectHeader) {
            requestBuilder.filter(new StripExpectHeader());
        }
        LinkedHashMultimap<String, Object> tokenValues = LinkedHashMultimap.create();
        tokenValues.put("jclouds.api-version", this.apiVersion);
        tokenValues.put("jclouds.build-version", this.buildVersion);
        Uris.UriBuilder uriBuilder = Uris.uriBuilder(((URI)endpoint.get()).toString());
        this.overridePathEncoding(uriBuilder, invocation);
        if (this.caller != null) {
            tokenValues.putAll(this.addPathAndGetTokens(this.caller, uriBuilder));
        }
        tokenValues.putAll(this.addPathAndGetTokens(invocation, uriBuilder));
        if (this.caller != null) {
            formParams = this.addFormParams(tokenValues, this.caller);
            formParams.putAll(this.addFormParams(tokenValues, invocation));
        } else {
            formParams = this.addFormParams(tokenValues, invocation);
        }
        Multimap<String, Object> queryParams = this.addQueryParams(tokenValues, invocation);
        if (this.caller != null) {
            headers = this.buildHeaders(tokenValues, this.caller);
            headers.putAll(this.buildHeaders(tokenValues, invocation));
        } else {
            headers = this.buildHeaders(tokenValues, invocation);
        }
        if (r != null) {
            headers.putAll(r.getHeaders());
        }
        if (this.shouldAddHostHeader(invocation)) {
            StringBuilder hostHeader = new StringBuilder(((URI)endpoint.get()).getHost());
            if (((URI)endpoint.get()).getPort() != -1) {
                hostHeader.append(":").append(((URI)endpoint.get()).getPort());
            }
            headers.put("Host", hostHeader.toString());
        }
        org.jclouds.io.Payload payload = null;
        for (HttpRequestOptions options : this.findOptionsIn(invocation)) {
            String stringPayload;
            this.injector.injectMembers(options);
            for (Map.Entry<String, String> header : options.buildRequestHeaders().entries()) {
                headers.put(header.getKey(), Strings2.replaceTokens(header.getValue(), tokenValues));
            }
            for (Map.Entry<String, String> query : options.buildQueryParameters().entries()) {
                queryParams.put(query.getKey(), Strings2.replaceTokens(query.getValue(), tokenValues));
            }
            for (Map.Entry<String, String> form : options.buildFormParameters().entries()) {
                formParams.put(form.getKey(), Strings2.replaceTokens(form.getValue(), tokenValues));
            }
            String pathSuffix = options.buildPathSuffix();
            if (pathSuffix != null) {
                uriBuilder.appendPath(pathSuffix);
            }
            if ((stringPayload = options.buildStringPayload()) == null) continue;
            payload = Payloads.newStringPayload(stringPayload);
        }
        if (queryParams.size() > 0) {
            uriBuilder.query(queryParams);
        }
        requestBuilder.headers(HttpUtils.filterOutContentHeaders(headers));
        requestBuilder.endpoint(uriBuilder.build(RestAnnotationProcessor.convertUnsafe(tokenValues)));
        if (payload == null) {
            PayloadEnclosing payloadEnclosing = RestAnnotationProcessor.findOrNull(invocation.getArgs(), PayloadEnclosing.class);
            org.jclouds.io.Payload payload2 = payload = payloadEnclosing != null ? payloadEnclosing.getPayload() : RestAnnotationProcessor.findOrNull(invocation.getArgs(), org.jclouds.io.Payload.class);
        }
        if ((parts = RestAnnotationProcessor.getParts(invocation, ImmutableMultimap.builder().putAll(tokenValues).putAll(formParams).build())).size() > 0) {
            if (formParams.size() > 0) {
                parts = Lists.newLinkedList(Iterables.concat(Iterables.transform(formParams.entries(), ENTRY_TO_PART), parts));
            }
            payload = new MultipartForm("--JCLOUDS--", parts);
        } else if (formParams.size() > 0) {
            payload = Payloads.newUrlEncodedFormPayload(Multimaps.transformValues(formParams, NullableToStringFunction.INSTANCE));
        } else if (headers.containsKey("Content-Type") && !HttpRequest.NON_PAYLOAD_METHODS.contains(requestMethod)) {
            if (payload == null) {
                payload = Payloads.newByteArrayPayload(new byte[0]);
            }
            payload.getContentMetadata().setContentType(Iterables.get(headers.get("Content-Type"), 0));
        }
        if (payload != null) {
            requestBuilder.payload(payload);
        }
        GeneratedHttpRequest request = requestBuilder.build();
        MapBinder mapBinder = this.getMapPayloadBinderOrNull(invocation);
        if (mapBinder != null) {
            Map<String, Object> mapParams;
            if (this.caller != null) {
                mapParams = this.buildPayloadParams(this.caller);
                mapParams.putAll(this.buildPayloadParams(invocation));
            } else {
                mapParams = this.buildPayloadParams(invocation);
            }
            if (invocation.getInvokable().isAnnotationPresent(PayloadParams.class)) {
                PayloadParams params = invocation.getInvokable().getAnnotation(PayloadParams.class);
                this.addMapPayload(mapParams, params, headers);
            }
            request = mapBinder.bindToRequest(request, mapParams);
        } else {
            request = this.decorateRequest(request);
        }
        if (request.getPayload() != null) {
            this.contentMetadataCodec.fromHeaders(request.getPayload().getContentMetadata(), headers);
        }
        this.utils.checkRequestHasRequiredProperties(request);
        return request;
    }

    private static <T> T findOrNull(Iterable<Object> args, Class<T> clazz) {
        return clazz.cast(Iterables.tryFind(args, Predicates.instanceOf(clazz)).orNull());
    }

    private static <K, V> Map<K, V> convertUnsafe(Multimap<K, V> in) {
        LinkedHashMap<K, V> out = Maps.newLinkedHashMap();
        for (Map.Entry<K, V> entry : in.entries()) {
            out.put(entry.getKey(), entry.getValue());
        }
        return ImmutableMap.copyOf(out);
    }

    private void overridePathEncoding(Uris.UriBuilder uriBuilder, Invocation invocation) {
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(SkipEncoding.class)) {
            uriBuilder.skipPathEncoding(Chars.asList(invocation.getInvokable().getOwnerType().getRawType().getAnnotation(SkipEncoding.class).value()));
        }
        if (invocation.getInvokable().isAnnotationPresent(SkipEncoding.class)) {
            uriBuilder.skipPathEncoding(Chars.asList(invocation.getInvokable().getAnnotation(SkipEncoding.class).value()));
        }
    }

    protected Optional<URI> findEndpoint(Invocation invocation) {
        Optional<URI> endpoint = this.getEndpointFor(invocation);
        if (endpoint.isPresent()) {
            this.logger.trace("using endpoint %s for %s", endpoint, invocation);
        }
        if (!endpoint.isPresent()) {
            this.logger.trace("looking up default endpoint for %s", invocation);
            endpoint = Optional.fromNullable(this.injector.getInstance(Key.get(uriSupplierLiteral, Provider.class)).get());
            if (endpoint.isPresent()) {
                this.logger.trace("using default endpoint %s for %s", endpoint, invocation);
            }
        }
        return endpoint;
    }

    private Multimap<String, Object> addPathAndGetTokens(Invocation invocation, Uris.UriBuilder uriBuilder) {
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(Path.class)) {
            uriBuilder.appendPath(invocation.getInvokable().getOwnerType().getRawType().getAnnotation(Path.class).value());
        }
        if (invocation.getInvokable().isAnnotationPresent(Path.class)) {
            uriBuilder.appendPath(invocation.getInvokable().getAnnotation(Path.class).value());
        }
        return this.getPathParamKeyValues(invocation);
    }

    private Multimap<String, Object> addFormParams(Multimap<String, ?> tokenValues, Invocation invocation) {
        FormParams form;
        LinkedListMultimap<String, Object> formMap = LinkedListMultimap.create();
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(FormParams.class)) {
            form = invocation.getInvokable().getOwnerType().getRawType().getAnnotation(FormParams.class);
            this.addForm(formMap, form, tokenValues);
        }
        if (invocation.getInvokable().isAnnotationPresent(FormParams.class)) {
            form = invocation.getInvokable().getAnnotation(FormParams.class);
            this.addForm(formMap, form, tokenValues);
        }
        for (Map.Entry<String, Object> form2 : this.getFormParamKeyValues(invocation).entries()) {
            formMap.put(form2.getKey(), Strings2.replaceTokens(form2.getValue().toString(), tokenValues));
        }
        return formMap;
    }

    private Multimap<String, Object> addQueryParams(Multimap<String, ?> tokenValues, Invocation invocation) {
        QueryParams query;
        LinkedListMultimap<String, Object> queryMap = LinkedListMultimap.create();
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(QueryParams.class)) {
            query = invocation.getInvokable().getOwnerType().getRawType().getAnnotation(QueryParams.class);
            this.addQuery(queryMap, query, tokenValues);
        }
        if (invocation.getInvokable().isAnnotationPresent(QueryParams.class)) {
            query = invocation.getInvokable().getAnnotation(QueryParams.class);
            this.addQuery(queryMap, query, tokenValues);
        }
        for (Map.Entry<String, Object> query2 : this.getQueryParamKeyValues(invocation).entries()) {
            queryMap.put(query2.getKey(), Strings2.replaceTokens(query2.getValue().toString(), tokenValues));
        }
        return queryMap;
    }

    private void addForm(Multimap<String, Object> formParams, FormParams form, Multimap<String, ?> tokenValues) {
        for (int i = 0; i < form.keys().length; ++i) {
            if (form.values()[i].equals("FORM_NULL")) {
                formParams.removeAll(form.keys()[i]);
                formParams.put(form.keys()[i], null);
                continue;
            }
            formParams.put(form.keys()[i], Strings2.replaceTokens(form.values()[i], tokenValues));
        }
    }

    private void addQuery(Multimap<String, Object> queryParams, QueryParams query, Multimap<String, ?> tokenValues) {
        for (int i = 0; i < query.keys().length; ++i) {
            if (query.values()[i].equals("QUERY_NULL")) {
                queryParams.removeAll(query.keys()[i]);
                queryParams.put(query.keys()[i], null);
                continue;
            }
            queryParams.put(query.keys()[i], Strings2.replaceTokens(query.values()[i], tokenValues));
        }
    }

    private void addMapPayload(Map<String, Object> postParams, PayloadParams mapDefaults, Multimap<String, String> headers) {
        for (int i = 0; i < mapDefaults.keys().length; ++i) {
            if (mapDefaults.values()[i].equals("MAP_PAYLOAD_NULL")) {
                postParams.put(mapDefaults.keys()[i], null);
                continue;
            }
            postParams.put(mapDefaults.keys()[i], Strings2.replaceTokens(mapDefaults.values()[i], headers));
        }
    }

    private List<HttpRequestFilter> getFiltersIfAnnotated(Invocation invocation) {
        HttpRequestFilter instance;
        ArrayList<HttpRequestFilter> filters = Lists.newArrayList();
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(RequestFilters.class)) {
            for (Class<? extends HttpRequestFilter> clazz : invocation.getInvokable().getOwnerType().getRawType().getAnnotation(RequestFilters.class).value()) {
                instance = this.injector.getInstance(clazz);
                filters.add(instance);
                this.logger.trace("adding filter %s from annotation on %s", instance, invocation.getInvokable().getOwnerType().getRawType().getName());
            }
        }
        if (invocation.getInvokable().isAnnotationPresent(RequestFilters.class)) {
            if (invocation.getInvokable().isAnnotationPresent(OverrideRequestFilters.class)) {
                filters.clear();
            }
            for (Class<? extends HttpRequestFilter> clazz : invocation.getInvokable().getAnnotation(RequestFilters.class).value()) {
                instance = this.injector.getInstance(clazz);
                filters.add(instance);
                this.logger.trace("adding filter %s from annotation on %s", instance, invocation.getInvokable().getName());
            }
        }
        return filters;
    }

    @VisibleForTesting
    static URI getEndpointInParametersOrNull(Invocation invocation, Injector injector) {
        Collection<Parameter> endpointParams = RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), EndpointParam.class);
        if (endpointParams.isEmpty()) {
            return null;
        }
        Preconditions.checkState(endpointParams.size() == 1, "invocation.getInvoked() %s has too many EndpointParam annotations", invocation.getInvokable());
        Parameter endpointParam = Iterables.get(endpointParams, 0);
        Function<Object, URI> parser = injector.getInstance(endpointParam.getAnnotation(EndpointParam.class).parser());
        int position = endpointParam.hashCode();
        try {
            URI returnVal = parser.apply(invocation.getArgs().get(position));
            Preconditions.checkArgument(returnVal != null, String.format("endpoint for [%s] not configured for %s", position, invocation.getInvokable()));
            return returnVal;
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(String.format("argument at index %d on invocation.getInvoked() %s was null", position, invocation.getInvokable()), e);
        }
    }

    private static Collection<Parameter> parametersWithAnnotation(Invokable<?, ?> invokable, final Class<? extends Annotation> annotationType) {
        return Collections2.filter(Reflection2.getInvokableParameters(invokable), new Predicate<Parameter>(){

            @Override
            public boolean apply(Parameter in) {
                return in.isAnnotationPresent(annotationType);
            }
        });
    }

    protected Optional<URI> getEndpointFor(Invocation invocation) {
        URI endpoint = RestAnnotationProcessor.getEndpointInParametersOrNull(invocation, this.injector);
        if (endpoint == null) {
            Endpoint annotation;
            if (invocation.getInvokable().isAnnotationPresent(Endpoint.class)) {
                annotation = invocation.getInvokable().getAnnotation(Endpoint.class);
            } else if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(Endpoint.class)) {
                annotation = invocation.getInvokable().getOwnerType().getRawType().getAnnotation(Endpoint.class);
            } else {
                this.logger.trace("no annotations on class or invocation.getInvoked(): %s", invocation.getInvokable());
                return Optional.absent();
            }
            endpoint = this.injector.getInstance(Key.get(uriSupplierLiteral, annotation.value())).get();
        }
        URI provider = this.injector.getInstance(Key.get(uriSupplierLiteral, Provider.class)).get();
        return Optional.fromNullable(RestAnnotationProcessor.addHostIfMissing(endpoint, provider));
    }

    @VisibleForTesting
    static URI addHostIfMissing(URI original, URI withHost) {
        Preconditions.checkNotNull(withHost, "URI withHost cannot be null");
        Preconditions.checkArgument(withHost.getHost() != null, "URI withHost must have host:" + withHost);
        if (original == null) {
            return null;
        }
        if (original.getHost() != null) {
            return original;
        }
        return withHost.resolve(original);
    }

    private MapBinder getMapPayloadBinderOrNull(Invocation invocation) {
        if (invocation.getArgs() != null) {
            for (Object arg : invocation.getArgs()) {
                if (arg instanceof Object[]) {
                    Object[] postBinders = (Object[])arg;
                    if (postBinders.length == 0) continue;
                    if (postBinders.length == 1) {
                        if (!(postBinders[0] instanceof MapBinder)) continue;
                        MapBinder binder = (MapBinder)postBinders[0];
                        this.injector.injectMembers(binder);
                        return binder;
                    }
                    if (!(postBinders[0] instanceof MapBinder)) continue;
                    throw new IllegalArgumentException("we currently do not support multiple varinvocation.getArgs() postBinders in: " + invocation.getInvokable().getName());
                }
                if (!(arg instanceof MapBinder)) continue;
                MapBinder binder = (MapBinder)arg;
                this.injector.injectMembers(binder);
                return binder;
            }
        }
        if (invocation.getInvokable().isAnnotationPresent(org.jclouds.rest.annotations.MapBinder.class)) {
            return this.injector.getInstance(invocation.getInvokable().getAnnotation(org.jclouds.rest.annotations.MapBinder.class).value());
        }
        if (invocation.getInvokable().isAnnotationPresent(Payload.class)) {
            return this.injector.getInstance(BindMapToStringPayload.class);
        }
        if (invocation.getInvokable().isAnnotationPresent(WrapWith.class)) {
            return this.injector.getInstance(BindToJsonPayloadWrappedWith.Factory.class).create(invocation.getInvokable().getAnnotation(WrapWith.class).value());
        }
        return null;
    }

    private boolean shouldAddHostHeader(Invocation invocation) {
        return invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(VirtualHost.class) || invocation.getInvokable().isAnnotationPresent(VirtualHost.class);
    }

    private GeneratedHttpRequest decorateRequest(GeneratedHttpRequest request) throws NegativeArraySizeException {
        Invocation invocation = request.getInvocation();
        List<Object> args = request.getInvocation().getArgs();
        ImmutableSet<Parameter> binderOrWrapWith = ImmutableSet.copyOf(Iterables.concat(RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), BinderParam.class), RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), WrapWith.class)));
        for (Parameter entry : binderOrWrapWith) {
            Object[] arg;
            int position = entry.hashCode();
            boolean shouldBreak = false;
            Binder binder = entry.isAnnotationPresent(BinderParam.class) ? this.injector.getInstance(entry.getAnnotation(BinderParam.class).value()) : this.injector.getInstance(BindToJsonPayloadWrappedWith.Factory.class).create(entry.getAnnotation(WrapWith.class).value());
            Object[] objectArray = arg = args.size() >= position + 1 ? args.get(position) : null;
            if (args.size() >= position + 1 && arg != null) {
                Class<?> parameterType = entry.getType().getRawType();
                Class<?> argType = arg.getClass();
                if (!argType.isArray() && parameterType.isArray()) {
                    int arrayLength = args.size() - Reflection2.getInvokableParameters(invocation.getInvokable()).size() + 1;
                    if (arrayLength == 0) break;
                    arg = (Object[])Array.newInstance(arg.getClass(), arrayLength);
                    System.arraycopy(args.toArray(), position, arg, 0, arrayLength);
                    shouldBreak = true;
                } else if (!(argType.isArray() && parameterType.isArray() || !arg.getClass().isArray())) {
                    Object[] payloadArray = arg;
                    Object[] objectArray2 = arg = payloadArray.length > 0 ? payloadArray[0] : null;
                }
                if (arg != null) {
                    request = binder.bindToRequest(request, arg);
                }
                if (!shouldBreak) continue;
                break;
            }
            if (position + 1 == Reflection2.getInvokableParameters(invocation.getInvokable()).size() && entry.getType().isArray() || entry.isAnnotationPresent(Nullable.class)) continue;
            Preconditions.checkNotNull(arg, invocation.getInvokable().getName() + " parameter " + (position + 1));
        }
        return request;
    }

    private Set<HttpRequestOptions> findOptionsIn(Invocation invocation) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        Iterator<Integer> i$ = invokableToIndexesOfOptions.getUnchecked(invocation.getInvokable()).iterator();
        while (i$.hasNext()) {
            int index;
            if (invocation.getArgs().size() < index + 1) continue;
            if (invocation.getArgs().get(index) instanceof Object[]) {
                for (Object option : (Object[])invocation.getArgs().get(index)) {
                    if (!(option instanceof HttpRequestOptions)) continue;
                    result.add((HttpRequestOptions)option);
                }
                continue;
            }
            for (index = i$.next().intValue(); index < invocation.getArgs().size(); ++index) {
                if (!(invocation.getArgs().get(index) instanceof HttpRequestOptions)) continue;
                result.add((HttpRequestOptions)invocation.getArgs().get(index));
            }
        }
        return result.build();
    }

    private Multimap<String, String> buildHeaders(Multimap<String, ?> tokenValues, Invocation invocation) {
        LinkedHashMultimap<String, String> headers = LinkedHashMultimap.create();
        this.addHeaderIfAnnotationPresentOnMethod(headers, invocation, tokenValues);
        for (Parameter headerParam : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), HeaderParam.class)) {
            HeaderParam key = headerParam.getAnnotation(HeaderParam.class);
            String value = invocation.getArgs().get(headerParam.hashCode()).toString();
            value = Strings2.replaceTokens(value, tokenValues);
            headers.put(key.value(), value);
        }
        this.addProducesIfPresentOnTypeOrMethod(headers, invocation);
        this.addConsumesIfPresentOnTypeOrMethod(headers, invocation);
        return headers;
    }

    private void addConsumesIfPresentOnTypeOrMethod(Multimap<String, String> headers, Invocation invocation) {
        Set<String> accept = this.getAcceptHeaders.apply(invocation);
        if (!accept.isEmpty()) {
            headers.replaceValues("Accept", accept);
        }
    }

    private void addProducesIfPresentOnTypeOrMethod(Multimap<String, String> headers, Invocation invocation) {
        Produces header;
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(Produces.class)) {
            header = invocation.getInvokable().getOwnerType().getRawType().getAnnotation(Produces.class);
            headers.replaceValues("Content-Type", Arrays.asList(header.value()));
        }
        if (invocation.getInvokable().isAnnotationPresent(Produces.class)) {
            header = invocation.getInvokable().getAnnotation(Produces.class);
            headers.replaceValues("Content-Type", Arrays.asList(header.value()));
        }
    }

    private void addHeaderIfAnnotationPresentOnMethod(Multimap<String, String> headers, Invocation invocation, Multimap<String, ?> tokenValues) {
        Headers header;
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(Headers.class)) {
            header = invocation.getInvokable().getOwnerType().getRawType().getAnnotation(Headers.class);
            RestAnnotationProcessor.addHeader(headers, header, tokenValues);
        }
        if (invocation.getInvokable().isAnnotationPresent(Headers.class)) {
            header = invocation.getInvokable().getAnnotation(Headers.class);
            RestAnnotationProcessor.addHeader(headers, header, tokenValues);
        }
    }

    private static void addHeader(Multimap<String, String> headers, Headers header, Multimap<String, ?> tokenValues) {
        for (int i = 0; i < header.keys().length; ++i) {
            String value = header.values()[i];
            value = Strings2.replaceTokens(value, tokenValues);
            headers.put(header.keys()[i], value);
        }
    }

    private static List<Part> getParts(Invocation invocation, Multimap<String, ?> tokenValues) {
        ImmutableList.Builder parts = ImmutableList.builder();
        for (Parameter param : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), PartParam.class)) {
            PartParam partParam = param.getAnnotation(PartParam.class);
            Part.PartOptions options = new Part.PartOptions();
            if (!"---NO_CONTENT_TYPE---".equals(partParam.contentType())) {
                options.contentType(partParam.contentType());
            }
            if (!"---NO_FILENAME---".equals(partParam.filename())) {
                options.filename(Strings2.replaceTokens(partParam.filename(), tokenValues));
            }
            Object arg = invocation.getArgs().get(param.hashCode());
            Preconditions.checkNotNull(arg, partParam.name());
            Part part = Part.create(partParam.name(), Payloads.newPayload(arg), options);
            parts.add(part);
        }
        return parts.build();
    }

    private Multimap<String, Object> getPathParamKeyValues(Invocation invocation) {
        LinkedHashMultimap<String, Object> pathParamValues = LinkedHashMultimap.create();
        for (Parameter param : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), PathParam.class)) {
            PathParam pathParam = param.getAnnotation(PathParam.class);
            String paramKey = pathParam.value();
            Optional<?> paramValue = this.getParamValue(invocation, param.getAnnotation(ParamParser.class), param.hashCode(), paramKey);
            if (!paramValue.isPresent()) continue;
            pathParamValues.put(paramKey, (Object)paramValue.get().toString());
        }
        return pathParamValues;
    }

    private Optional<?> getParamValue(Invocation invocation, @Nullable ParamParser extractor, int argIndex, String paramKey) {
        Object arg = invocation.getArgs().get(argIndex);
        if (extractor != null && this.checkPresentOrNullable(invocation, paramKey, argIndex, arg)) {
            arg = this.injector.getInstance(extractor.value()).apply(arg);
        }
        this.checkPresentOrNullable(invocation, paramKey, argIndex, arg);
        return Optional.fromNullable(arg);
    }

    private boolean checkPresentOrNullable(Invocation invocation, String paramKey, int argIndex, Object arg) {
        if (arg == null && !Reflection2.getInvokableParameters(invocation.getInvokable()).get(argIndex).isAnnotationPresent(Nullable.class)) {
            throw new NullPointerException(String.format("param{%s} for invocation %s.%s", paramKey, invocation.getInvokable().getOwnerType().getRawType().getSimpleName(), invocation.getInvokable().getName()));
        }
        return true;
    }

    private Multimap<String, Object> getFormParamKeyValues(Invocation invocation) {
        LinkedHashMultimap<String, Object> formParamValues = LinkedHashMultimap.create();
        for (Parameter param : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), FormParam.class)) {
            FormParam formParam = param.getAnnotation(FormParam.class);
            String paramKey = formParam.value();
            Optional<?> paramValue = this.getParamValue(invocation, param.getAnnotation(ParamParser.class), param.hashCode(), paramKey);
            if (!paramValue.isPresent()) continue;
            formParamValues.put(paramKey, (Object)paramValue.get().toString());
        }
        return formParamValues;
    }

    private Multimap<String, Object> getQueryParamKeyValues(Invocation invocation) {
        LinkedHashMultimap<String, Object> queryParamValues = LinkedHashMultimap.create();
        for (Parameter param : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), QueryParam.class)) {
            QueryParam queryParam = param.getAnnotation(QueryParam.class);
            String paramKey = queryParam.value();
            Optional<?> paramValue = this.getParamValue(invocation, param.getAnnotation(ParamParser.class), param.hashCode(), paramKey);
            if (!paramValue.isPresent()) continue;
            if (paramValue.get() instanceof Iterable) {
                Iterable<String> iterableStrings = Iterables.transform((Iterable)Iterable.class.cast(paramValue.get()), Functions.toStringFunction());
                queryParamValues.putAll(paramKey, iterableStrings);
                continue;
            }
            queryParamValues.put(paramKey, (Object)paramValue.get().toString());
        }
        return queryParamValues;
    }

    private Map<String, Object> buildPayloadParams(Invocation invocation) {
        LinkedHashMap<String, Object> payloadParamValues = Maps.newLinkedHashMap();
        for (Parameter param : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), PayloadParam.class)) {
            PayloadParam payloadParam = param.getAnnotation(PayloadParam.class);
            String paramKey = payloadParam.value();
            Optional<?> paramValue = this.getParamValue(invocation, param.getAnnotation(ParamParser.class), param.hashCode(), paramKey);
            if (!paramValue.isPresent()) continue;
            payloadParamValues.put(paramKey, paramValue.get());
        }
        return payloadParamValues;
    }

    public String toString() {
        String callerString = this.caller != null ? String.format("%s.%s%s", this.caller.getInvokable().getOwnerType().getRawType().getSimpleName(), this.caller.getInvokable().getName(), this.caller.getArgs()) : null;
        return Objects.toStringHelper("").omitNullValues().add("caller", callerString).toString();
    }

    private static enum NullableToStringFunction implements Function<Object, String>
    {
        INSTANCE;


        @Override
        public String apply(Object o) {
            if (o == null) {
                return null;
            }
            return o.toString();
        }
    }
}

