/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class TrustedSignersStaxUnmarshaller
implements Unmarshaller<TrustedSigners, StaxUnmarshallerContext> {
    private static TrustedSignersStaxUnmarshaller instance;

    @Override
    public TrustedSigners unmarshall(StaxUnmarshallerContext context) throws Exception {
        TrustedSigners trustedSigners = new TrustedSigners();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return trustedSigners;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    trustedSigners.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    trustedSigners.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Items/AwsAccountNumber", targetDepth)) continue;
                trustedSigners.getItems().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return trustedSigners;
    }

    public static TrustedSignersStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TrustedSignersStaxUnmarshaller();
        }
        return instance;
    }
}

