/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.logging.Logger;
import org.jclouds.util.Throwables2;

public abstract class BaseHttpCommandExecutorService<Q>
implements HttpCommandExecutorService {
    protected final HttpUtils utils;
    protected final ContentMetadataCodec contentMetadataCodec;
    protected final DelegatingRetryHandler retryHandler;
    protected final IOExceptionRetryHandler ioRetryHandler;
    protected final DelegatingErrorHandler errorHandler;
    protected final ListeningExecutorService ioExecutor;
    @Resource
    protected Logger logger = Logger.NULL;
    @Resource
    @Named(value="jclouds.headers")
    protected Logger headerLog = Logger.NULL;
    protected final HttpWire wire;

    @Inject
    protected BaseHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, @Named(value="jclouds.io-worker-threads") ListeningExecutorService ioExecutor, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire) {
        this.utils = Preconditions.checkNotNull(utils, "utils");
        this.contentMetadataCodec = Preconditions.checkNotNull(contentMetadataCodec, "contentMetadataCodec");
        this.retryHandler = Preconditions.checkNotNull(retryHandler, "retryHandler");
        this.ioRetryHandler = Preconditions.checkNotNull(ioRetryHandler, "ioRetryHandler");
        this.errorHandler = Preconditions.checkNotNull(errorHandler, "errorHandler");
        this.ioExecutor = Preconditions.checkNotNull(ioExecutor, "ioExecutor");
        this.wire = Preconditions.checkNotNull(wire, "wire");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse invoke(HttpCommand command) {
        HttpResponse response = null;
        while (true) {
            HttpRequest request = command.getCurrentRequest();
            Q nativeRequest = null;
            try {
                for (HttpRequestFilter filter : request.getFilters()) {
                    request = filter.filter(request);
                }
                HttpUtils.checkRequestHasContentLengthOrChunkedEncoding(request, "After filtering, the request has neither chunked encoding nor content length: " + request);
                this.logger.debug("Sending request %s: %s", request.hashCode(), request.getRequestLine());
                HttpUtils.wirePayloadIfEnabled(this.wire, request);
                this.utils.logRequest(this.headerLog, request, ">>");
                nativeRequest = this.convert(request);
                response = this.invoke(nativeRequest);
                this.logger.debug("Receiving response %s: %s", request.hashCode(), response.getStatusLine());
                this.utils.logResponse(this.headerLog, response, "<<");
                if (response.getPayload() != null && this.wire.enabled()) {
                    this.wire.input(response);
                }
                nativeRequest = null;
                int statusCode = response.getStatusCode();
                if (statusCode < 300 || !this.shouldContinue(command, response)) break;
                continue;
            }
            catch (Exception e) {
                IOException ioe = Throwables2.getFirstThrowableOfType(e, IOException.class);
                if (ioe != null && this.ioRetryHandler.shouldRetryRequest(command, ioe)) continue;
                command.setException(new HttpResponseException(e.getMessage() + " connecting to " + command.getCurrentRequest().getRequestLine(), command, null, (Throwable)e));
            }
            finally {
                this.cleanup(nativeRequest);
                continue;
            }
            break;
        }
        if (command.getException() != null) {
            throw Throwables.propagate(command.getException());
        }
        return response;
    }

    private boolean shouldContinue(HttpCommand command, HttpResponse response) {
        boolean shouldContinue = false;
        if (this.retryHandler.shouldRetryRequest(command, response)) {
            shouldContinue = true;
        } else {
            this.errorHandler.handleError(command, response);
        }
        return shouldContinue;
    }

    @Override
    public ListenableFuture<HttpResponse> submit(HttpCommand command) {
        HttpRequest request = command.getCurrentRequest();
        HttpUtils.checkRequestHasContentLengthOrChunkedEncoding(request, "if the request has a payload, it must be set to chunked encoding or specify a content length: " + request);
        return this.ioExecutor.submit(new HttpResponseCallable(command));
    }

    protected abstract Q convert(HttpRequest var1) throws IOException, InterruptedException;

    protected abstract HttpResponse invoke(Q var1) throws IOException, InterruptedException;

    protected abstract void cleanup(Q var1);

    public class HttpResponseCallable
    implements Callable<HttpResponse> {
        private final HttpCommand command;

        public HttpResponseCallable(HttpCommand command) {
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HttpResponse call() throws Exception {
            try {
                HttpResponse httpResponse = BaseHttpCommandExecutorService.this.invoke(this.command);
                return httpResponse;
            }
            finally {
                if (this.command.getException() != null) {
                    throw this.command.getException();
                }
            }
        }

        public String toString() {
            return this.command.toString();
        }
    }
}

