/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.BaseEncoding;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.logging.Logger;

@ImplementedBy(value=DefaultContentMetadataCodec.class)
public interface ContentMetadataCodec {
    public Multimap<String, String> toHeaders(ContentMetadata var1);

    public void fromHeaders(MutableContentMetadata var1, Multimap<String, String> var2);

    public Date parseExpires(String var1);

    public static class DefaultContentMetadataCodec
    implements ContentMetadataCodec {
        @Resource
        protected Logger logger = Logger.NULL;
        private final DateCodec httpExpiresDateCodec;

        @Inject
        public DefaultContentMetadataCodec(DateCodecFactory dateCodecs) {
            this.httpExpiresDateCodec = dateCodecs.rfc1123();
        }

        protected DateCodec getExpiresDateCodec() {
            return this.httpExpiresDateCodec;
        }

        @Override
        public Multimap<String, String> toHeaders(ContentMetadata md) {
            ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
            if (md.getContentType() != null) {
                builder.put("Content-Type", md.getContentType());
            }
            if (md.getContentDisposition() != null) {
                builder.put("Content-Disposition", md.getContentDisposition());
            }
            if (md.getContentEncoding() != null) {
                builder.put("Content-Encoding", md.getContentEncoding());
            }
            if (md.getContentLanguage() != null) {
                builder.put("Content-Language", md.getContentLanguage());
            }
            if (md.getContentLength() != null) {
                builder.put("Content-Length", md.getContentLength() + "");
            }
            if (md.getContentMD5() != null) {
                builder.put("Content-MD5", BaseEncoding.base64().encode(md.getContentMD5()));
            }
            if (md.getExpires() != null) {
                builder.put("Expires", this.getExpiresDateCodec().toString(md.getExpires()));
            }
            return builder.build();
        }

        @Override
        public void fromHeaders(MutableContentMetadata contentMetadata, Multimap<String, String> headers) {
            boolean chunked = Iterables.any(headers.entries(), new Predicate<Map.Entry<String, String>>(){

                @Override
                public boolean apply(Map.Entry<String, String> input) {
                    return "Transfer-Encoding".equalsIgnoreCase(input.getKey()) && "chunked".equalsIgnoreCase(input.getValue());
                }
            });
            for (Map.Entry<String, String> header : headers.entries()) {
                if (!chunked && "Content-Length".equalsIgnoreCase(header.getKey())) {
                    contentMetadata.setContentLength(Long.valueOf(header.getValue()));
                    continue;
                }
                if ("Content-MD5".equalsIgnoreCase(header.getKey())) {
                    contentMetadata.setContentMD5(BaseEncoding.base64().decode(header.getValue()));
                    continue;
                }
                if ("Content-Type".equalsIgnoreCase(header.getKey())) {
                    contentMetadata.setContentType(header.getValue());
                    continue;
                }
                if ("Content-Disposition".equalsIgnoreCase(header.getKey())) {
                    contentMetadata.setContentDisposition(header.getValue());
                    continue;
                }
                if ("Content-Encoding".equalsIgnoreCase(header.getKey())) {
                    contentMetadata.setContentEncoding(header.getValue());
                    continue;
                }
                if ("Content-Language".equalsIgnoreCase(header.getKey())) {
                    contentMetadata.setContentLanguage(header.getValue());
                    continue;
                }
                if (!"Expires".equalsIgnoreCase(header.getKey())) continue;
                contentMetadata.setExpires(this.parseExpires(header.getValue()));
            }
        }

        @Override
        public Date parseExpires(String expires) {
            try {
                return expires != null ? this.getExpiresDateCodec().toDate(expires) : null;
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("Invalid Expires header (%s); should be in RFC-1123 format; treating as already expired: %s", expires, e.getMessage());
                return new Date(0L);
            }
        }
    }
}

