/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeCborUnmarshallers;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.ImmutableMapParameter;
import com.amazonaws.util.json.SdkCborGenerator;
import com.amazonaws.util.json.SdkJsonGenerator;
import com.amazonaws.util.json.StructuredJsonGenerator;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkProtectedApi
public class SdkJsonProtocolFactory {
    private static final JsonFactory JSON_FACTORY;
    @Deprecated
    public static final JsonFactory DEFAULT_FACTORY;
    private static final JsonFactory CBOR_FACTORY;
    private static final String DEFAULT_JSON_VERSION = "1.0";
    private static final String CONTENT_TYPE_JSON_PREFIX = "application/x-amz-json-";
    @Deprecated
    public static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.0";
    private static final String CONTENT_TYPE_CBOR_PREFIX = "application/x-amz-cbor-";
    private static final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> JSON_SCALAR_UNMARSHALLERS;
    @Deprecated
    public static final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> DEFAULT_SCALAR_UNMARSHALLERS;
    private static final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> CBOR_SCALAR_UNMARSHALLERS;

    private static boolean isCborEnabled(boolean supportsCbor) {
        return supportsCbor && !SDKGlobalConfiguration.isCborDisabled();
    }

    public static StructuredJsonGenerator createWriter(boolean supportsCbor, String protocolVersion) {
        return SdkJsonProtocolFactory.isCborEnabled(supportsCbor) ? new SdkCborGenerator(CBOR_FACTORY, CONTENT_TYPE_CBOR_PREFIX + protocolVersion) : new SdkJsonGenerator(JSON_FACTORY, CONTENT_TYPE_JSON_PREFIX + protocolVersion);
    }

    public static JsonResponseHandler createResponseHandler(Unmarshaller<?, JsonUnmarshallerContext> responseUnmarshaller, boolean supportsCbor) {
        return SdkJsonProtocolFactory.isCborEnabled(supportsCbor) ? new JsonResponseHandler(responseUnmarshaller, CBOR_SCALAR_UNMARSHALLERS, CBOR_FACTORY) : new JsonResponseHandler(responseUnmarshaller, JSON_SCALAR_UNMARSHALLERS, JSON_FACTORY);
    }

    public static JsonErrorResponseHandlerV2 createErrorResponseHandler(List<JsonErrorUnmarshallerV2> errorUnmarshallers, boolean supportsCbor) {
        return SdkJsonProtocolFactory.isCborEnabled(supportsCbor) ? new JsonErrorResponseHandlerV2(errorUnmarshallers, CBOR_FACTORY) : new JsonErrorResponseHandlerV2(errorUnmarshallers, JSON_FACTORY);
    }

    static {
        DEFAULT_FACTORY = JSON_FACTORY = new JsonFactory();
        CBOR_FACTORY = new CBORFactory();
        JSON_SCALAR_UNMARSHALLERS = new ImmutableMapParameter.Builder<Class<String>, SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller>().put(String.class, SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance()).put(Double.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.DoubleJsonUnmarshaller.getInstance())).put(Integer.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.IntegerJsonUnmarshaller.getInstance())).put(BigInteger.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.BigIntegerJsonUnmarshaller.getInstance())).put(BigDecimal.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.BigDecimalJsonUnmarshaller.getInstance())).put(Boolean.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance())).put(Float.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.FloatJsonUnmarshaller.getInstance())).put(Long.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.LongJsonUnmarshaller.getInstance())).put(Byte.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.ByteJsonUnmarshaller.getInstance())).put(Date.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance())).put(ByteBuffer.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.ByteBufferJsonUnmarshaller.getInstance())).put(Character.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.CharacterJsonUnmarshaller.getInstance())).put(Short.class, (SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller)((Object)SimpleTypeJsonUnmarshallers.ShortJsonUnmarshaller.getInstance())).build();
        DEFAULT_SCALAR_UNMARSHALLERS = JSON_SCALAR_UNMARSHALLERS;
        CBOR_SCALAR_UNMARSHALLERS = new ImmutableMapParameter.Builder<Class<String>, SimpleTypeCborUnmarshallers.StringCborUnmarshaller>().put(String.class, SimpleTypeCborUnmarshallers.StringCborUnmarshaller.getInstance()).put(Double.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.DoubleCborUnmarshaller.getInstance())).put(Integer.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.IntegerCborUnmarshaller.getInstance())).put(BigInteger.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.BigIntegerCborUnmarshaller.getInstance())).put(BigDecimal.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.BigDecimalCborUnmarshaller.getInstance())).put(Boolean.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.BooleanCborUnmarshaller.getInstance())).put(Float.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.FloatCborUnmarshaller.getInstance())).put(Long.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.LongCborUnmarshaller.getInstance())).put(Byte.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.ByteCborUnmarshaller.getInstance())).put(Date.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.DateCborUnmarshaller.getInstance())).put(ByteBuffer.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.ByteBufferCborUnmarshaller.getInstance())).put(Short.class, (SimpleTypeCborUnmarshallers.StringCborUnmarshaller)((Object)SimpleTypeCborUnmarshallers.ShortCborUnmarshaller.getInstance())).build();
    }
}

