/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.GetBlobsInListStrategy;
import org.jclouds.blobstore.strategy.ListBlobsInContainer;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;

@Singleton
public class GetAllBlobsInListAndRetryOnFailure
implements GetBlobsInListStrategy {
    protected final ListBlobsInContainer getAllBlobMetadata;
    protected final BackoffLimitedRetryHandler retryHandler;
    protected final AsyncBlobStore ablobstore;
    protected final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    GetAllBlobsInListAndRetryOnFailure(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ListBlobsInContainer getAllBlobMetadata, AsyncBlobStore ablobstore, BackoffLimitedRetryHandler retryHandler) {
        this.userExecutor = userExecutor;
        this.ablobstore = ablobstore;
        this.getAllBlobMetadata = getAllBlobMetadata;
        this.retryHandler = retryHandler;
    }

    @Override
    public Iterable<Blob> execute(final String container, ListContainerOptions options) {
        Set<? extends BlobMetadata> list = this.getAllBlobMetadata.execute(container, options);
        return FutureIterables.transformParallel(list, new Function<BlobMetadata, ListenableFuture<? extends Blob>>(){

            @Override
            public ListenableFuture<Blob> apply(BlobMetadata from) {
                return GetAllBlobsInListAndRetryOnFailure.this.ablobstore.getBlob(container, from.getName());
            }
        }, this.userExecutor, this.maxTime, this.logger, String.format("getting from containerName: %s", container), this.retryHandler, 3);
    }
}

