/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class Link {
    @Named(value="rel")
    protected Relation relation;
    protected String type;
    protected URI href;

    public static Link create(Relation relation, URI href) {
        return new Link(relation, null, href);
    }

    public static Link create(Relation relation, String type, URI href) {
        return new Link(relation, type, href);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Link.builder().fromLink(this);
    }

    @ConstructorProperties(value={"rel", "type", "href"})
    protected Link(Relation relation, @Nullable String type, URI href) {
        this.relation = Preconditions.checkNotNull(relation, "relation");
        this.type = type;
        this.href = Preconditions.checkNotNull(href, "href");
    }

    public Relation getRelation() {
        return this.relation;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public URI getHref() {
        return this.href;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Link) {
            Link other = (Link)Link.class.cast(object);
            return Objects.equal((Object)this.relation, (Object)other.relation) && Objects.equal(this.type, other.type) && Objects.equal(this.href, other.href);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.relation, this.type, this.href});
    }

    public String toString() {
        return Objects.toStringHelper("").add("relation", (Object)this.relation).add("type", this.type).add("href", this.href).toString();
    }

    public static class Builder {
        protected Relation relation;
        protected String type;
        protected URI href;

        public Builder relation(Relation relation) {
            this.relation = Preconditions.checkNotNull(relation, "relation");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder href(URI href) {
            this.href = Preconditions.checkNotNull(href, "href");
            return this;
        }

        public Link build() {
            return new Link(this.relation, this.type, this.href);
        }

        public Builder fromLink(Link from) {
            return this.relation(from.getRelation()).type(from.getType()).href(from.getHref());
        }
    }

    public static enum Relation {
        SELF,
        BOOKMARK,
        DESCRIBEDBY,
        ALTERNATE,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static Relation fromValue(String v) {
            try {
                return Relation.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

