/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.functions.ParseSystemAndUserMetadataFromHeaders;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.openstack.swift.blobstore.functions.ResourceToObjectInfo;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.utils.ETagUtils;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseObjectInfoFromHeaders
implements Function<HttpResponse, MutableObjectInfoWithMetadata>,
InvocationContext<ParseObjectInfoFromHeaders> {
    private final ParseSystemAndUserMetadataFromHeaders blobMetadataParser;
    private final ResourceToObjectInfo blobToObjectInfo;
    private String container;

    @Inject
    public ParseObjectInfoFromHeaders(ParseSystemAndUserMetadataFromHeaders blobMetadataParser, ResourceToObjectInfo blobToObjectInfo) {
        this.blobMetadataParser = blobMetadataParser;
        this.blobToObjectInfo = blobToObjectInfo;
    }

    @Override
    public MutableObjectInfoWithMetadata apply(HttpResponse from) {
        MutableBlobMetadata base = this.blobMetadataParser.apply(from);
        MutableObjectInfoWithMetadata to = this.blobToObjectInfo.apply(base);
        to.setBytes(HttpUtils.attemptToParseSizeAndRangeFromHeaders(from));
        to.setContainer(this.container);
        to.setUri(base.getUri());
        String eTagHeader = from.getFirstHeaderOrNull("ETag");
        if (eTagHeader != null) {
            to.setHash(ETagUtils.convertHexETagToByteArray(eTagHeader));
        }
        to.setObjectManifest(from.getFirstHeaderOrNull("X-Object-Manifest"));
        return to;
    }

    @Override
    public ParseObjectInfoFromHeaders setContext(HttpRequest request) {
        this.blobMetadataParser.setContext(request);
        Preconditions.checkArgument(request instanceof GeneratedHttpRequest, "note this handler requires a GeneratedHttpRequest");
        return this.setContainer(((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)).getInvocation().getArgs().get(0).toString());
    }

    private ParseObjectInfoFromHeaders setContainer(String container) {
        this.container = container;
        return this;
    }
}

