/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class Parameter {
    static final List<Class<?>> TYPES = Arrays.asList(Pageable.class, Sort.class);
    private static final String NAMED_PARAMETER_TEMPLATE = ":%s";
    private static final String POSITION_PARAMETER_TEMPLATE = "?%s";
    private final MethodParameter parameter;
    private final boolean isDynamicProjectionParameter;

    protected Parameter(MethodParameter parameter) {
        Assert.notNull(parameter);
        this.parameter = parameter;
        this.isDynamicProjectionParameter = Parameter.isDynamicProjectionParameter(parameter);
    }

    public boolean isSpecialParameter() {
        return this.isDynamicProjectionParameter || TYPES.contains(this.parameter.getParameterType());
    }

    public boolean isBindable() {
        return !this.isSpecialParameter();
    }

    public boolean isDynamicProjectionParameter() {
        return this.isDynamicProjectionParameter;
    }

    public String getPlaceholder() {
        if (this.isNamedParameter()) {
            return String.format(NAMED_PARAMETER_TEMPLATE, this.getName());
        }
        return String.format(POSITION_PARAMETER_TEMPLATE, this.getIndex());
    }

    public int getIndex() {
        return this.parameter.getParameterIndex();
    }

    public boolean isNamedParameter() {
        return !this.isSpecialParameter() && this.getName() != null;
    }

    public String getName() {
        Param annotation = this.parameter.getParameterAnnotation(Param.class);
        return annotation == null ? this.parameter.getParameterName() : annotation.value();
    }

    public Class<?> getType() {
        return this.parameter.getParameterType();
    }

    public boolean isExplicitlyNamed() {
        return this.parameter.hasParameterAnnotation(Param.class);
    }

    public String toString() {
        return String.format("%s:%s", this.isNamedParameter() ? this.getName() : "#" + this.getIndex(), this.getType().getName());
    }

    boolean isPageable() {
        return Pageable.class.isAssignableFrom(this.getType());
    }

    boolean isSort() {
        return Sort.class.isAssignableFrom(this.getType());
    }

    private static boolean isDynamicProjectionParameter(MethodParameter parameter) {
        Method method = parameter.getMethod();
        ClassTypeInformation<?> ownerType = ClassTypeInformation.from(parameter.getDeclaringClass());
        TypeInformation parameterTypes = (TypeInformation)ownerType.getParameterTypes(method).get(parameter.getParameterIndex());
        TypeInformation returnType = ClassTypeInformation.fromReturnTypeOf(method);
        if (!parameterTypes.getType().equals(Class.class)) {
            return false;
        }
        TypeInformation<?> bound = parameterTypes.getTypeArguments().get(0);
        return bound.equals(returnType.getActualType());
    }
}

