/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;

public class JsonBall
implements Comparable<String>,
CharSequence {
    public static final Pattern JSON_STRING_PATTERN = Pattern.compile("^[^\"\\{\\[].*[^\\{\\[\"]$");
    public static final Pattern JSON_NUMBER_PATTERN = Pattern.compile("^[0-9]*\\.?[0-9]*$");
    public static final Pattern JSON_BOOLEAN_PATTERN = Pattern.compile("^(true|false)$");
    private final String value;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonBall other = (JsonBall)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return this.value;
    }

    public JsonBall(double value) {
        this.value = value + "";
    }

    public JsonBall(int value) {
        this.value = value + "";
    }

    public JsonBall(long value) {
        this.value = value + "";
    }

    public JsonBall(boolean value) {
        this.value = value + "";
    }

    public JsonBall(String value) {
        this.value = JsonBall.quoteStringIfNotNumberOrBoolean(Preconditions.checkNotNull(value, "value"));
    }

    private static String quoteStringIfNotNumberOrBoolean(String in) {
        if (JSON_STRING_PATTERN.matcher(in).find() && !JSON_NUMBER_PATTERN.matcher(in).find() && !JSON_BOOLEAN_PATTERN.matcher(in).find()) {
            return "\"" + in + "\"";
        }
        return in;
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public int compareTo(String o) {
        return this.value.compareTo(o);
    }
}

