/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import com.amazonaws.services.s3.AmazonS3;
import java.util.HashMap;
import org.duracloud.snapshot.dto.task.CompleteSnapshotTaskParameters;
import org.duracloud.snapshot.dto.task.CompleteSnapshotTaskResult;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompleteSnapshotTaskRunner
implements TaskRunner {
    private Logger log = LoggerFactory.getLogger(CompleteSnapshotTaskRunner.class);
    private StorageProvider snapshotProvider;
    private SnapshotStorageProvider unwrappedSnapshotProvider;
    private AmazonS3 s3Client;

    public CompleteSnapshotTaskRunner(StorageProvider snapshotProvider, SnapshotStorageProvider unwrappedSnapshotProvider, AmazonS3 s3Client) {
        this.snapshotProvider = snapshotProvider;
        this.unwrappedSnapshotProvider = unwrappedSnapshotProvider;
        this.s3Client = s3Client;
    }

    @Override
    public String getName() {
        return "complete-snapshot";
    }

    @Override
    public String performTask(String taskParameters) {
        CompleteSnapshotTaskParameters taskParams = CompleteSnapshotTaskParameters.deserialize(taskParameters);
        String spaceId = taskParams.getSpaceId();
        String bucketName = this.unwrappedSnapshotProvider.getBucketName(spaceId);
        this.log.info("Performing Complete Snapshot Task for spaceID: " + spaceId);
        this.s3Client.deleteBucketLifecycleConfiguration(bucketName);
        this.unwrappedSnapshotProvider.setNewSpaceProperties(spaceId, new HashMap<String, String>());
        this.log.info("Complete Snapshot Task for space " + spaceId + " completed successfully");
        String result = "Snapshot complete was successful";
        return new CompleteSnapshotTaskResult(result).serialize();
    }
}

