/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DefaultRepositoryConfiguration<T extends RepositoryConfigurationSource>
implements RepositoryConfiguration<T> {
    public static final String DEFAULT_REPOSITORY_IMPLEMENTATION_POSTFIX = "Impl";
    private static final QueryLookupStrategy.Key DEFAULT_QUERY_LOOKUP_STRATEGY = QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND;
    private final T configurationSource;
    private final BeanDefinition definition;

    public DefaultRepositoryConfiguration(T configurationSource, BeanDefinition definition) {
        Assert.notNull(configurationSource);
        Assert.notNull(definition);
        this.configurationSource = configurationSource;
        this.definition = definition;
    }

    public String getBeanId() {
        return StringUtils.uncapitalize(ClassUtils.getShortName(this.getRepositoryFactoryBeanName()));
    }

    @Override
    public Object getQueryLookupStrategyKey() {
        Object configuredStrategy = this.configurationSource.getQueryLookupStrategyKey();
        return configuredStrategy != null ? configuredStrategy : DEFAULT_QUERY_LOOKUP_STRATEGY;
    }

    @Override
    public Iterable<String> getBasePackages() {
        return this.configurationSource.getBasePackages();
    }

    @Override
    public String getRepositoryInterface() {
        return this.definition.getBeanClassName();
    }

    public RepositoryConfigurationSource getConfigSource() {
        return this.configurationSource;
    }

    @Override
    public String getNamedQueriesLocation() {
        return this.configurationSource.getNamedQueryLocation();
    }

    @Override
    public String getImplementationClassName() {
        return ClassUtils.getShortName(this.getRepositoryInterface()) + this.getImplementationPostfix();
    }

    @Override
    public String getImplementationBeanName() {
        return StringUtils.uncapitalize(this.getImplementationClassName());
    }

    public String getImplementationPostfix() {
        String configuredPostfix = this.configurationSource.getRepositoryImplementationPostfix();
        return StringUtils.hasText(configuredPostfix) ? configuredPostfix : DEFAULT_REPOSITORY_IMPLEMENTATION_POSTFIX;
    }

    @Override
    public Object getSource() {
        return this.configurationSource.getSource();
    }

    @Override
    public T getConfigurationSource() {
        return this.configurationSource;
    }

    @Override
    public String getRepositoryFactoryBeanName() {
        return this.configurationSource.getRepositoryFactoryBeanName();
    }

    @Override
    public String getRepositoryBaseClassName() {
        return this.configurationSource.getRepositoryBaseClassName();
    }

    @Override
    public boolean isLazyInit() {
        return this.definition.isLazyInit();
    }
}

