/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.taskproducertool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.audit.task.AuditTask;
import org.duracloud.common.queue.aws.SQSTaskQueue;
import org.duracloud.common.queue.task.NoopTask;
import org.duracloud.common.queue.task.SpaceCentricTypedTask;
import org.duracloud.common.queue.task.Task;
import org.duracloud.common.queue.task.TypedTask;
import org.duracloud.mill.bit.BitIntegrityCheckReportTask;
import org.duracloud.mill.bit.BitIntegrityCheckTask;
import org.duracloud.mill.common.storageprovider.StorageStatsTask;
import org.duracloud.mill.task.DuplicationTask;

public class Driver {
    private Driver() {
    }

    private static void usage() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(80);
        help.printHelp(Driver.class.getCanonicalName(), Driver.getOptions());
    }

    private static CommandLine parseArgs(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(Driver.getOptions(), args);
        }
        catch (ParseException e) {
            System.err.println(e);
            Driver.die();
        }
        return cmd;
    }

    private static void die() {
        Driver.usage();
        System.exit(1);
    }

    private static Options getOptions() {
        Options options = new Options();
        Option subdomain = new Option("s", "subdomain", true, "A duracloud subdomain");
        subdomain.setArgs(1);
        subdomain.setArgName("subdomain");
        subdomain.setRequired(true);
        options.addOption(subdomain);
        Option queue = new Option("q", "queue", true, "A task queue name");
        queue.setArgs(1);
        queue.setArgName("queue");
        queue.setRequired(true);
        options.addOption(queue);
        Option username = new Option("u", "username", true, "The queue service username");
        username.setArgs(1);
        username.setArgName("username");
        options.addOption(username);
        Option password = new Option("p", "password", true, "The queue service password");
        password.setArgs(1);
        password.setArgName("password");
        options.addOption(password);
        Option type = new Option("t", "type", true, "The type of operation: NOOP, DUP, BIT, AUDIT, BIT_REPORT, STORAGE_STATS");
        type.setArgs(1);
        type.setArgName("type");
        type.setRequired(true);
        options.addOption(type);
        Option sourceStorageProviderId = new Option("a", "source-provider-id", true, "The id of the source storage provider");
        sourceStorageProviderId.setArgs(1);
        sourceStorageProviderId.setArgName("id");
        options.addOption(sourceStorageProviderId);
        Option destStorageProviderId = new Option("b", "dest-provider-id", true, "The id of the destination storage provider");
        destStorageProviderId.setArgs(1);
        destStorageProviderId.setArgName("id");
        options.addOption(destStorageProviderId);
        Option spaceId = new Option("d", "space-id", true, "The id of the space");
        spaceId.setArgs(1);
        spaceId.setArgName("spaceId");
        options.addOption(spaceId);
        Option contentId = new Option("c", "content-id", true, "The id of the source content");
        contentId.setArgs(1);
        contentId.setArgName("contentId");
        options.addOption(contentId);
        Option contentIdFile = new Option("f", "content-id-file", true, "A file containing a list of content ids");
        contentIdFile.setArgs(1);
        contentIdFile.setArgName("content-id-file");
        options.addOption(contentIdFile);
        Option action = new Option("n", "action", true, "An action field for audit task (ADDED_CONTENT, DELETED_CONTENT) ");
        action.setArgs(1);
        action.setArgName("action");
        options.addOption(action);
        Option contentSize = new Option("z", "content-size", true, "A content size for audit tasks ( in bytes)");
        contentSize.setArgs(1);
        contentSize.setArgName("content-size");
        options.addOption(contentSize);
        Option checksum = new Option("k", "checksum", true, "a checksum field");
        checksum.setArgs(1);
        checksum.setArgName("checksum");
        options.addOption(checksum);
        return options;
    }

    public static void main(String[] args) {
        try {
            String contentIdFilePath;
            CommandLine cmd = Driver.parseArgs(args);
            String queue = cmd.getOptionValue("q");
            String username = cmd.getOptionValue("u");
            String password = cmd.getOptionValue("p");
            String subdomain = cmd.getOptionValue("s");
            Task.Type taskType = Task.Type.valueOf(cmd.getOptionValue("t").toUpperCase());
            String sourceStoreId = cmd.getOptionValue("a");
            String destStoreId = cmd.getOptionValue("b");
            String spaceId = cmd.getOptionValue("d");
            String contentId = cmd.getOptionValue("c");
            String action = cmd.getOptionValue("n");
            String contentSize = cmd.getOptionValue("z");
            String checksum = cmd.getOptionValue("k");
            ArrayList<String> contentIds = new ArrayList<String>();
            if (contentId != null) {
                contentIds.add(contentId);
            }
            if ((contentIdFilePath = cmd.getOptionValue("f")) != null) {
                File file = new File(contentIdFilePath);
                if (!file.exists()) {
                    throw new IOException("contentIds file does not exist: " + file.getAbsolutePath());
                }
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (StringUtils.isBlank(line)) continue;
                    contentIds.add(line.trim());
                }
            }
            if (contentIds.size() == 0) {
                throw new Exception("You must specify at least one content id either using the -c parameter or -f parameter.");
            }
            if (username != null) {
                System.setProperty("aws.accessKeyId", username);
            }
            if (password != null) {
                System.setProperty("aws.secretKey", password);
            }
            SQSTaskQueue taskQueue = new SQSTaskQueue(queue);
            for (String content : contentIds) {
                SpaceCentricTypedTask task;
                SpaceCentricTypedTask typedTask;
                if (taskType.equals((Object)Task.Type.DUP)) {
                    DuplicationTask dupTask = new DuplicationTask();
                    dupTask.setSourceStoreId(sourceStoreId);
                    dupTask.setDestStoreId(destStoreId);
                    dupTask.setContentId(contentId);
                    typedTask = dupTask;
                } else if (taskType.equals((Object)Task.Type.NOOP)) {
                    NoopTask noopTask = new NoopTask();
                    typedTask = noopTask;
                } else if (taskType.equals((Object)Task.Type.AUDIT)) {
                    AuditTask auditTask = new AuditTask();
                    auditTask.setContentChecksum(checksum != null ? checksum : "no-checksum-provided");
                    auditTask.setAction(action != null ? AuditTask.ActionType.valueOf(action).name() : AuditTask.ActionType.ADD_CONTENT.name());
                    auditTask.setContentSize(contentSize != null ? contentSize : "0");
                    if (!AuditTask.ActionType.DELETE_CONTENT.name().equals(action)) {
                        auditTask.setContentMimetype("application/octet-stream");
                    }
                    auditTask.setDateTime("" + System.currentTimeMillis());
                    auditTask.setUserId("root");
                    auditTask.setContentId(content);
                    typedTask = auditTask;
                } else if (taskType.equals((Object)Task.Type.BIT_REPORT)) {
                    typedTask = task = new BitIntegrityCheckReportTask();
                } else if (taskType.equals((Object)Task.Type.BIT)) {
                    task = new BitIntegrityCheckTask();
                    ((TypedTask)task).setContentId(contentId);
                    typedTask = task;
                } else if (taskType.equals((Object)Task.Type.STORAGE_STATS)) {
                    typedTask = new StorageStatsTask();
                } else {
                    throw new RuntimeException("taskType " + taskType + " not supported.");
                }
                typedTask.setAccount(subdomain);
                typedTask.setSpaceId(spaceId);
                typedTask.setStoreId(sourceStoreId);
                taskQueue.put(typedTask.writeTask());
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

