/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.StringUtils;

final class NamedQuery
extends AbstractJpaQuery {
    private static final String CANNOT_EXTRACT_QUERY = "Your persistence provider does not support extracting the JPQL query from a named query thus you can't use Pageable inside your query method. Make sure you have a JpaDialect configured at your EntityManagerFactoryBean as this affects discovering the concrete persistence provider.";
    private static final Logger LOG = LoggerFactory.getLogger(NamedQuery.class);
    private final String queryName;
    private final String countQueryName;
    private final String countProjection;
    private final QueryExtractor extractor;
    private final boolean namedCountQueryIsPresent;
    private final StringQuery declaredQuery;

    private NamedQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        Query query;
        String queryString;
        boolean cantExtractQuery;
        this.queryName = method.getNamedQueryName();
        this.countQueryName = method.getNamedCountQueryName();
        this.extractor = method.getQueryExtractor();
        this.countProjection = method.getCountQueryProjection();
        JpaParameters parameters = method.getParameters();
        if (parameters.hasSortParameter()) {
            throw new IllegalStateException(String.format("Finder method %s is backed by a NamedQuery and must not contain a sort parameter as we cannot modify the query! Use @Query instead!", method));
        }
        this.namedCountQueryIsPresent = NamedQuery.hasNamedQuery(em, this.countQueryName);
        boolean weNeedToCreateCountQuery = !this.namedCountQueryIsPresent && method.getParameters().hasPageableParameter();
        boolean bl = cantExtractQuery = !this.extractor.canExtractQuery();
        if (weNeedToCreateCountQuery && cantExtractQuery) {
            throw QueryCreationException.create((QueryMethod)method, CANNOT_EXTRACT_QUERY);
        }
        if (parameters.hasPageableParameter()) {
            LOG.warn("Finder method {} is backed by a NamedQuery but contains a Pageable parameter! Sorting delivered via this Pageable will not be applied!", (Object)method);
        }
        this.declaredQuery = StringUtils.hasText(queryString = this.extractor.extractQueryString(query = em.createNamedQuery(this.queryName))) ? new StringQuery(queryString) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasNamedQuery(EntityManager em, String queryName) {
        EntityManager lookupEm = em.getEntityManagerFactory().createEntityManager();
        try {
            lookupEm.createNamedQuery(queryName);
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Did not find named query {}", (Object)queryName);
            boolean bl = false;
            return bl;
        }
        finally {
            lookupEm.close();
        }
    }

    public static RepositoryQuery lookupFrom(JpaQueryMethod method, EntityManager em) {
        String queryName = method.getNamedQueryName();
        LOG.debug("Looking up named query {}", (Object)queryName);
        if (!NamedQuery.hasNamedQuery(em, queryName)) {
            return null;
        }
        try {
            NamedQuery query = new NamedQuery(method, em);
            LOG.debug("Found named query {}!", (Object)queryName);
            return query;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    protected Query doCreateQuery(Object[] values) {
        EntityManager em = this.getEntityManager();
        JpaQueryMethod queryMethod = this.getQueryMethod();
        ResultProcessor processor = queryMethod.getResultProcessor().withDynamicProjection(new ParametersParameterAccessor(queryMethod.getParameters(), values));
        Class<?> typeToRead = this.getTypeToRead(processor.getReturnedType());
        TypedQuery<?> query = typeToRead == null ? em.createNamedQuery(this.queryName) : em.createNamedQuery(this.queryName, typeToRead);
        return this.createBinder(values).bindAndPrepare(query);
    }

    @Override
    protected TypedQuery<Long> doCreateCountQuery(Object[] values) {
        EntityManager em = this.getEntityManager();
        TypedQuery<Long> countQuery = null;
        if (this.namedCountQueryIsPresent) {
            countQuery = em.createNamedQuery(this.countQueryName, Long.class);
        } else {
            if (this.declaredQuery == null) {
                throw new IllegalStateException("Cannot derive count query without an extracted source query!");
            }
            String countQueryString = QueryUtils.createCountQueryFor(this.declaredQuery.getQueryString(), this.countProjection);
            countQuery = em.createQuery(countQueryString, Long.class);
        }
        return this.createBinder(values).bind(countQuery);
    }

    @Override
    protected Class<?> getTypeToRead(ReturnedType returnedType) {
        if (this.getQueryMethod().isNativeQuery()) {
            Class<?> type = returnedType.getReturnedType();
            Class<?> domainType = returnedType.getDomainType();
            if (domainType.isAssignableFrom(type)) {
                return type;
            }
            if (type.isAssignableFrom(domainType)) {
                return domainType;
            }
            return type.isInterface() ? Tuple.class : null;
        }
        return this.declaredQuery != null && !this.declaredQuery.hasConstructorExpression() ? super.getTypeToRead(returnedType) : null;
    }
}

