/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListCachePoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListCachePoliciesRequestMarshaller
implements Marshaller<Request<ListCachePoliciesRequest>, ListCachePoliciesRequest> {
    @Override
    public Request<ListCachePoliciesRequest> marshall(ListCachePoliciesRequest listCachePoliciesRequest) {
        if (listCachePoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListCachePoliciesRequest> request = new DefaultRequest<ListCachePoliciesRequest>(listCachePoliciesRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2020-05-31/cache-policy";
        request.setResourcePath(uriResourcePath);
        if (listCachePoliciesRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString(listCachePoliciesRequest.getType()));
        }
        if (listCachePoliciesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listCachePoliciesRequest.getMarker()));
        }
        if (listCachePoliciesRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString(listCachePoliciesRequest.getMaxItems()));
        }
        return request;
    }
}

