/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListOriginAccessControlsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListOriginAccessControlsRequestMarshaller
implements Marshaller<Request<ListOriginAccessControlsRequest>, ListOriginAccessControlsRequest> {
    @Override
    public Request<ListOriginAccessControlsRequest> marshall(ListOriginAccessControlsRequest listOriginAccessControlsRequest) {
        if (listOriginAccessControlsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListOriginAccessControlsRequest> request = new DefaultRequest<ListOriginAccessControlsRequest>(listOriginAccessControlsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2020-05-31/origin-access-control";
        request.setResourcePath(uriResourcePath);
        if (listOriginAccessControlsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listOriginAccessControlsRequest.getMarker()));
        }
        if (listOriginAccessControlsRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString(listOriginAccessControlsRequest.getMaxItems()));
        }
        return request;
    }
}

