/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.TrafficConfig;
import com.amazonaws.services.cloudfront.model.transform.ContinuousDeploymentSingleHeaderConfigStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.ContinuousDeploymentSingleWeightConfigStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class TrafficConfigStaxUnmarshaller
implements Unmarshaller<TrafficConfig, StaxUnmarshallerContext> {
    private static TrafficConfigStaxUnmarshaller instance;

    @Override
    public TrafficConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        TrafficConfig trafficConfig = new TrafficConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return trafficConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SingleWeightConfig", targetDepth)) {
                    trafficConfig.setSingleWeightConfig(ContinuousDeploymentSingleWeightConfigStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SingleHeaderConfig", targetDepth)) {
                    trafficConfig.setSingleHeaderConfig(ContinuousDeploymentSingleHeaderConfigStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Type", targetDepth)) continue;
                trafficConfig.setType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return trafficConfig;
    }

    public static TrafficConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TrafficConfigStaxUnmarshaller();
        }
        return instance;
    }
}

