/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleemail.model.DeliveryOptions;
import com.amazonaws.services.simpleemail.model.PutConfigurationSetDeliveryOptionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutConfigurationSetDeliveryOptionsRequestMarshaller
implements Marshaller<Request<PutConfigurationSetDeliveryOptionsRequest>, PutConfigurationSetDeliveryOptionsRequest> {
    @Override
    public Request<PutConfigurationSetDeliveryOptionsRequest> marshall(PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) {
        DeliveryOptions deliveryOptions;
        if (putConfigurationSetDeliveryOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutConfigurationSetDeliveryOptionsRequest> request = new DefaultRequest<PutConfigurationSetDeliveryOptionsRequest>(putConfigurationSetDeliveryOptionsRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "PutConfigurationSetDeliveryOptions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putConfigurationSetDeliveryOptionsRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(putConfigurationSetDeliveryOptionsRequest.getConfigurationSetName()));
        }
        if ((deliveryOptions = putConfigurationSetDeliveryOptionsRequest.getDeliveryOptions()) != null && deliveryOptions.getTlsPolicy() != null) {
            request.addParameter("DeliveryOptions.TlsPolicy", StringUtils.fromString(deliveryOptions.getTlsPolicy()));
        }
        return request;
    }
}

