/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.text.MessageFormat;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshot.dto.task.RestartSnapshotTaskParameters;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.storage.error.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartSnapshotTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(RestartSnapshotTaskRunner.class);
    private String dcHost;

    public RestartSnapshotTaskRunner(String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
    }

    @Override
    public String getName() {
        return "restart-snapshot";
    }

    @Override
    public String performTask(String taskParameters) {
        RestartSnapshotTaskParameters params = RestartSnapshotTaskParameters.deserialize(taskParameters);
        String snapshotId = params.getSnapshotId();
        return this.callBridge(this.createRestHelper(), this.buildBridgeURL(snapshotId));
    }

    protected String buildBridgeURL(String snapshotId) {
        return MessageFormat.format("{0}/snapshot/{1}/restart", this.buildBridgeBaseURL(), snapshotId);
    }

    protected String callBridge(RestHttpHelper restHelper, String bridgeURL) {
        this.log.info("Making bridge call to restart snapshot. URL: {}", (Object)bridgeURL);
        try {
            RestHttpHelper.HttpResponse response = restHelper.post(bridgeURL, null, null);
            int statusCode = response.getStatusCode();
            if (statusCode != 202) {
                throw new RuntimeException("Unexpected response code: " + statusCode);
            }
            return response.getResponseBody();
        }
        catch (Exception e) {
            throw new TaskException("Exception encountered attempting to restart snapshot. Error reported: " + e.getMessage(), e);
        }
    }
}

