/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public final class Limit {
    private final String verb;
    private final String unit;
    private final int value;
    private final Optional<Integer> remaining;
    @Named(value="next-available")
    private final Optional<Date> nextAvailable;

    @ConstructorProperties(value={"verb", "unit", "value", "remaining", "next-available"})
    private Limit(String verb, String unit, int value, @Nullable Integer remaining, @Nullable Date nextAvailable) {
        this.verb = Preconditions.checkNotNull(verb, "verb");
        this.unit = Preconditions.checkNotNull(unit, "unit", unit);
        this.value = value;
        this.remaining = Optional.fromNullable(remaining);
        this.nextAvailable = Optional.fromNullable(nextAvailable);
    }

    public String getVerb() {
        return this.verb;
    }

    public String getUnit() {
        return this.unit;
    }

    public int getValue() {
        return this.value;
    }

    public Optional<Integer> getRemaining() {
        return this.remaining;
    }

    public Optional<Date> getNextAvailable() {
        return this.nextAvailable;
    }

    public int hashCode() {
        return Objects.hashCode(this.verb, this.unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Limit that = (Limit)Limit.class.cast(obj);
        return Objects.equal(this.verb, that.verb) && Objects.equal(this.unit, that.unit);
    }

    public String toString() {
        return Objects.toStringHelper(this).omitNullValues().add("verb", this.verb).add("unit", this.unit).add("value", this.value).add("remaining", this.remaining.orNull()).add("nextAvailable", this.nextAvailable.orNull()).toString();
    }
}

