/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit;

import java.util.HashSet;
import java.util.Set;
import org.duracloud.audit.task.AuditTask;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.dup.DuplicationPolicy;
import org.duracloud.mill.dup.DuplicationPolicyManager;
import org.duracloud.mill.dup.DuplicationStorePolicy;
import org.duracloud.mill.task.DuplicationTask;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicationTaskProducingProcessor
implements TaskProcessor {
    private static Logger log = LoggerFactory.getLogger(DuplicationTaskProducingProcessor.class);
    private AuditTask task;
    private TaskQueue duplicationTaskQueue;
    private DuplicationPolicyManager duplicationPolicyManager;

    public DuplicationTaskProducingProcessor(AuditTask task, TaskQueue duplicationTaskQueue, DuplicationPolicyManager duplicationPolicyManager) {
        this.task = task;
        this.duplicationTaskQueue = duplicationTaskQueue;
        this.duplicationPolicyManager = duplicationPolicyManager;
    }

    @Override
    public void execute() throws TaskExecutionFailedException {
        if (this.isDuplicatable(this.task)) {
            this.applyDuplicationPolicy(this.task);
        } else {
            log.warn("This message {} is not duplicable: it will be ignored.");
        }
    }

    private boolean isDuplicatable(AuditTask task) {
        if (task.getAction() == null) {
            return false;
        }
        try {
            AuditTask.ActionType action = AuditTask.ActionType.valueOf(task.getAction());
            return action.equals((Object)AuditTask.ActionType.ADD_CONTENT) || action.equals((Object)AuditTask.ActionType.SET_CONTENT_PROPERTIES) || action.equals((Object)AuditTask.ActionType.COPY_CONTENT) || action.equals((Object)AuditTask.ActionType.DELETE_CONTENT) || action.equals((Object)AuditTask.ActionType.DELETE_SPACE);
        }
        catch (IllegalArgumentException e) {
            log.warn("failed to get enum value of " + task.getAction() + ": " + e.getMessage());
            return false;
        }
    }

    protected void applyDuplicationPolicy(AuditTask task) {
        Set<DuplicationStorePolicy> dupStorePolicies;
        String account = task.getAccount();
        DuplicationPolicy policy = this.duplicationPolicyManager.getDuplicationPolicy(account);
        if (policy == null) {
            log.warn("no policy found for account \"{}\": {} will be ignored. ", (Object)account, (Object)task);
            return;
        }
        log.debug("applying duplication policies to {} for {}", (Object)task, (Object)account);
        String storeId = task.getStoreId();
        String spaceId = task.getSpaceId();
        String contentId = task.getContentId();
        if (contentId == null) {
            contentId = "";
        }
        if ((dupStorePolicies = policy.getDuplicationStorePolicies(spaceId)) != null && !dupStorePolicies.isEmpty()) {
            HashSet<Task> tasks = null;
            for (DuplicationStorePolicy dupStorePolicy : dupStorePolicies) {
                if (dupStorePolicy.getSrcStoreId().equals(storeId)) {
                    log.debug("policy's sourceStoreId matches messageStoreId: policy={}; messageStoreId={}", (Object)dupStorePolicy, (Object)storeId);
                    DuplicationTask dupTask = new DuplicationTask();
                    dupTask.setAccount(account);
                    dupTask.setDestStoreId(dupStorePolicy.getDestStoreId());
                    dupTask.setSpaceId(spaceId);
                    dupTask.setContentId(contentId);
                    dupTask.setSourceStoreId(storeId);
                    log.info("adding duplication task to the task queue: {}", (Object)dupTask);
                    if (tasks == null) {
                        tasks = new HashSet<Task>();
                    }
                    tasks.add(dupTask.writeTask());
                    continue;
                }
                log.debug("policy's sourceStoreId does not match messageStoreId: policy={}; messageStoreId={}", (Object)dupStorePolicy, (Object)storeId);
            }
            if (tasks != null) {
                this.duplicationTaskQueue.put(tasks);
            }
        } else {
            log.info("no duplication policies for {} on account {}", (Object)spaceId, (Object)account);
        }
    }
}

