/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.bit;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.duracloud.audit.task.AuditTask;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.mill.bit.BitCheckExecutionState;
import org.duracloud.mill.bit.BitIntegrityCheckTask;
import org.duracloud.mill.bit.BitIntegrityCheckTaskExecutionFailedException;
import org.duracloud.mill.bit.BitIntegrityErrorTask;
import org.duracloud.mill.bit.BitIntegrityHelper;
import org.duracloud.mill.bit.HandlerResult;
import org.duracloud.mill.bitlog.BitIntegrityResult;
import org.duracloud.mill.bitlog.BitLogStore;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.storage.domain.StorageProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BitCheckHandler {
    private static Logger log = LoggerFactory.getLogger(BitCheckHandler.class);
    private static final Set<StorageProviderType> CONTENT_CHECKSUM_CALCULATING_STORAGE_PROVIDERS = new HashSet<StorageProviderType>();

    BitCheckHandler() {
    }

    private static void initializeContentChecksumCalculatingStorageProviders() {
        CONTENT_CHECKSUM_CALCULATING_STORAGE_PROVIDERS.add(StorageProviderType.AMAZON_S3);
        CONTENT_CHECKSUM_CALCULATING_STORAGE_PROVIDERS.add(StorageProviderType.SDSC);
    }

    public final boolean handle(BitCheckExecutionState bitCheckState) throws TaskExecutionFailedException {
        HandlerResult result = this.handleImpl(bitCheckState);
        if (result.isHandled()) {
            if (!result.getResult().equals((Object)BitIntegrityResult.IGNORE)) {
                String contentChecksum = null;
                String storeChecksum = bitCheckState.getStoreChecksum();
                if (storeChecksum != null && this.isContentChecksumCalculated(bitCheckState.getStorageProviderType())) {
                    contentChecksum = bitCheckState.getContentChecksumHelper().getContentChecksum(storeChecksum);
                }
                this.writeResult(result.getResult(), bitCheckState.getManifestChecksum(), bitCheckState.getStoreChecksum(), contentChecksum, bitCheckState.getBitLogStore(), bitCheckState.getStorageProviderType(), bitCheckState.getTask(), result.getMessage());
            }
            return true;
        }
        return false;
    }

    protected String buildFailureMessage(String message, BitIntegrityCheckTask bitTask, StorageProviderType storageProviderType) {
        return BitIntegrityHelper.buildFailureMessage(message, bitTask, storageProviderType);
    }

    protected boolean isContentChecksumOkay(BitCheckExecutionState state, String otherChecksum) throws TaskExecutionFailedException {
        if (this.isContentChecksumCalculated(state.getStorageProviderType())) {
            return otherChecksum.equals(state.getContentChecksumHelper().getContentChecksum(otherChecksum));
        }
        return true;
    }

    protected boolean isContentChecksumCalculated(StorageProviderType storageProviderType) {
        return CONTENT_CHECKSUM_CALCULATING_STORAGE_PROVIDERS.contains((Object)storageProviderType);
    }

    protected abstract HandlerResult handleImpl(BitCheckExecutionState var1) throws TaskExecutionFailedException;

    protected void addErrorTask(BitCheckExecutionState state, String message) throws TaskExecutionFailedException {
        String manifestChecksum = state.getManifestChecksum();
        BitIntegrityCheckTask bitTask = state.getTask();
        TaskQueue queue = state.getBitErrorQueue();
        String storeChecksum = state.getStoreChecksum();
        BitIntegrityErrorTask task = new BitIntegrityErrorTask();
        task.setAccount(bitTask.getAccount());
        task.setStoreId(bitTask.getStoreId());
        task.setSpaceId(bitTask.getSpaceId());
        task.setContentId(bitTask.getContentId());
        task.setDescription(message);
        if (storeChecksum != null && this.isContentChecksumCalculated(state.getStorageProviderType())) {
            task.setContentChecksum(state.getContentChecksumHelper().getContentChecksum(storeChecksum));
        }
        task.setStoreType(state.getStorageProviderType());
        task.setStoreChecksum(storeChecksum);
        task.setManifestChecksum(manifestChecksum);
        queue.put(task.writeTask());
    }

    private void writeResult(final BitIntegrityResult result, final String manifestChecksum, final String storeChecksum, final String contentChecksum, final BitLogStore bitLogStore, final StorageProviderType storageProviderType, final BitIntegrityCheckTask bitTask, final String details) throws TaskExecutionFailedException {
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public String retry() throws Exception {
                    bitLogStore.write(bitTask.getAccount(), bitTask.getStoreId(), bitTask.getSpaceId(), bitTask.getContentId(), new Date(System.currentTimeMillis()), storageProviderType, result, contentChecksum, storeChecksum, manifestChecksum, details == null ? "--" : details);
                    return "success";
                }
            });
        }
        catch (Exception e) {
            throw new BitIntegrityCheckTaskExecutionFailedException(this.buildFailureMessage("Could not write result to BitLogStore", bitTask, storageProviderType), e);
        }
        String message = MessageFormat.format("Checksum result={0} account={1} storeId={2} storeType={3} space={4} contentId={5} manifestChecksum={6} storeChecksum={7} contentChecksum={8}", new Object[]{result, bitTask.getAccount(), bitTask.getStoreId(), storageProviderType, bitTask.getSpaceId(), bitTask.getContentId(), manifestChecksum, storeChecksum, contentChecksum});
        if (result == BitIntegrityResult.SUCCESS) {
            log.info(message);
        } else {
            log.error(message);
        }
    }

    protected boolean addAuditTask(BitCheckExecutionState state) {
        BitIntegrityCheckTask bitTask = state.getTask();
        Map<String, String> properties = state.getContentProperties();
        String mimeType = properties.get("content-mimetype");
        String size = properties.get("content-size");
        String user = properties.get("creator");
        try {
            AuditTask task = new AuditTask();
            task.setAccount(bitTask.getAccount());
            task.setStoreId(bitTask.getStoreId());
            task.setSpaceId(bitTask.getSpaceId());
            task.setContentId(bitTask.getContentId());
            task.setContentChecksum(state.getStoreChecksum());
            task.setContentMimetype(mimeType);
            task.setContentSize(size);
            task.setUserId(user);
            task.setContentProperties(state.getContentProperties());
            task.setAction(AuditTask.ActionType.ADD_CONTENT.name());
            task.setDateTime(String.valueOf(System.currentTimeMillis()));
            state.getAuditTaskQueue().put(task.writeTask());
            return true;
        }
        catch (Exception e) {
            log.error(this.buildFailureMessage("failed to add task to audit queue", bitTask, state.getStorageProviderType()), e);
            return false;
        }
    }

    protected boolean isLastAttempt(BitIntegrityCheckTask task) {
        return task.getAttempts() == 4;
    }

    protected boolean isPenultimateAttempt(BitIntegrityCheckTask task) {
        return task.getAttempts() == 3;
    }

    static {
        BitCheckHandler.initializeContentChecksumCalculatingStorageProviders();
    }
}

