/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.noop;

import java.util.Map;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopTaskProcessor
implements TaskProcessor {
    private static Logger log = LoggerFactory.getLogger(NoopTaskProcessor.class);
    private Task task;
    private static long completedCount = 0L;

    public NoopTaskProcessor(Task task) {
        this.task = task;
    }

    @Override
    public void execute() throws TaskExecutionFailedException {
        StringBuilder results = new StringBuilder();
        results.append("Executing NOOP Task Processor\nTask Properties:\n");
        Map<String, String> props = this.task.getProperties();
        for (String key : props.keySet()) {
            results.append(key);
            results.append(": ");
            results.append(props.get(key));
            results.append("\n");
        }
        log.info(results.toString());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ++completedCount;
    }

    public static long getCompletedCount() {
        return completedCount;
    }
}

