/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.util.Assert;

class StoredProcedureAttributes {
    private final boolean namedStoredProcedure;
    private final String procedureName;
    private final String outputParameterName;
    private final Class<?> outputParameterType;

    public StoredProcedureAttributes(String procedureName, String outputParameterName, Class<?> outputParameterType, boolean namedStoredProcedure) {
        Assert.notNull(procedureName, "ProcedureName must not be null!");
        Assert.notNull(outputParameterType, "OutputParameterType must not be null!");
        this.procedureName = procedureName;
        this.outputParameterName = outputParameterName;
        this.outputParameterType = outputParameterType;
        this.namedStoredProcedure = namedStoredProcedure;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public String getOutputParameterName() {
        return this.outputParameterName;
    }

    public Class<?> getOutputParameterType() {
        return this.outputParameterType;
    }

    public boolean isNamedStoredProcedure() {
        return this.namedStoredProcedure;
    }

    public boolean hasReturnValue() {
        return !Void.TYPE.equals(this.outputParameterType) && !Void.class.equals(this.outputParameterType);
    }
}

