/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.Field;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.util.ReflectionUtils;

public class DirectFieldAccessFallbackBeanWrapper
extends BeanWrapperImpl {
    public DirectFieldAccessFallbackBeanWrapper(Object entity) {
        super(entity);
    }

    public DirectFieldAccessFallbackBeanWrapper(Class<?> type) {
        super(type);
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        try {
            return super.getPropertyValue(propertyName);
        }
        catch (NotReadablePropertyException e) {
            Field field = ReflectionUtils.findField(this.getWrappedClass(), propertyName);
            if (field == null) {
                throw new NotReadablePropertyException(this.getWrappedClass(), propertyName, "Could not find field for property during fallback access!");
            }
            ReflectionUtils.makeAccessible(field);
            return ReflectionUtils.getField(field, this.getWrappedInstance());
        }
    }

    @Override
    public void setPropertyValue(String propertyName, Object value) {
        try {
            super.setPropertyValue(propertyName, value);
        }
        catch (NotWritablePropertyException e) {
            Field field = ReflectionUtils.findField(this.getWrappedClass(), propertyName);
            if (field == null) {
                throw new NotWritablePropertyException(this.getWrappedClass(), propertyName, "Could not find field for property during fallback access!");
            }
            ReflectionUtils.makeAccessible(field);
            ReflectionUtils.setField(field, this.getWrappedInstance(), value);
        }
    }
}

