/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.scan.spi;

import org.hibernate.jpa.boot.archive.spi.ArchiveContext;
import org.hibernate.jpa.boot.archive.spi.ArchiveEntry;
import org.hibernate.jpa.boot.internal.PackageDescriptorImpl;
import org.hibernate.jpa.boot.scan.spi.AbstractJavaArtifactArchiveEntryHandler;
import org.hibernate.jpa.boot.scan.spi.ScanOptions;
import org.hibernate.jpa.boot.spi.PackageDescriptor;

public class PackageInfoArchiveEntryHandler
extends AbstractJavaArtifactArchiveEntryHandler {
    private final Callback callback;

    public PackageInfoArchiveEntryHandler(ScanOptions scanOptions, Callback callback) {
        super(scanOptions);
        this.callback = callback;
    }

    @Override
    public void handleEntry(ArchiveEntry entry, ArchiveContext context) {
        if (entry.getNameWithinArchive().equals("package-info.class")) {
            return;
        }
        if (!this.isListedOrDetectable(context, entry.getName())) {
            return;
        }
        this.notifyMatchedPackage(this.toPackageDescriptor(entry));
    }

    protected PackageDescriptor toPackageDescriptor(ArchiveEntry entry) {
        String packageInfoFilePath = entry.getNameWithinArchive();
        String packageName = packageInfoFilePath.substring(0, packageInfoFilePath.lastIndexOf(47)).replace('/', '.');
        return new PackageDescriptorImpl(packageName, entry.getStreamAccess());
    }

    protected final void notifyMatchedPackage(PackageDescriptor packageDescriptor) {
        this.callback.locatedPackage(packageDescriptor);
    }

    public static interface Callback {
        public void locatedPackage(PackageDescriptor var1);
    }
}

