/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.javax.annotation.Nullable;

public class LocationImpl
implements Location {
    private final LocationScope scope;
    private final String id;
    private final String description;
    private final Location parent;
    private final Set<String> iso3166Codes;
    private final Map<String, Object> metadata;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationImpl that = (LocationImpl)LocationImpl.class.cast(o);
        return Objects.equal((Object)this.scope, (Object)that.scope) && Objects.equal(this.id, that.id) && Objects.equal(this.parent, that.parent);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.scope, this.id, this.parent});
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper("").omitNullValues().add("scope", (Object)this.scope).add("id", this.id).add("description", this.description);
        if (this.parent != null) {
            helper.add("parent", this.parent.getId());
        }
        if (this.iso3166Codes.size() > 0) {
            helper.add("iso3166Codes", this.iso3166Codes);
        }
        if (this.metadata.size() > 0) {
            helper.add("metadata", this.metadata);
        }
        return helper.toString();
    }

    public LocationImpl(LocationScope scope, String id, String description, @Nullable Location parent, Iterable<String> iso3166Codes, Map<String, Object> metadata) {
        this.scope = Preconditions.checkNotNull(scope, "scope");
        this.id = Preconditions.checkNotNull(id, "id");
        this.description = Preconditions.checkNotNull(description, "description");
        this.metadata = ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata"));
        this.iso3166Codes = ImmutableSet.copyOf(Preconditions.checkNotNull(iso3166Codes, "iso3166Codes"));
        this.parent = parent;
    }

    @Override
    public LocationScope getScope() {
        return this.scope;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Location getParent() {
        return this.parent;
    }

    @Override
    public Set<String> getIso3166Codes() {
        return this.iso3166Codes;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }
}

