/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.blobstore.strategy.internal.MultipartNamingStrategy;
import org.jclouds.openstack.swift.blobstore.strategy.internal.MultipartUploadSlicingAlgorithm;
import org.jclouds.openstack.swift.blobstore.strategy.internal.MultipartUploadStrategy;

public class SequentialMultipartUploadStrategy
implements MultipartUploadStrategy {
    @Resource
    @Named(value="jclouds.blobstore")
    private Logger logger = Logger.NULL;
    private final CommonSwiftClient client;
    private final Provider<BlobBuilder> blobBuilders;
    private final BlobToObject blob2Object;
    private final MultipartUploadSlicingAlgorithm algorithm;
    private final PayloadSlicer slicer;
    private final MultipartNamingStrategy namingStrategy;

    @Inject
    public SequentialMultipartUploadStrategy(CommonSwiftClient client, Provider<BlobBuilder> blobBuilders, BlobToObject blob2Object, MultipartUploadSlicingAlgorithm algorithm, PayloadSlicer slicer, MultipartNamingStrategy namingStrategy) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.blobBuilders = Preconditions.checkNotNull(blobBuilders, "blobBuilders");
        this.blob2Object = Preconditions.checkNotNull(blob2Object, "blob2Object");
        this.algorithm = Preconditions.checkNotNull(algorithm, "algorithm");
        this.slicer = Preconditions.checkNotNull(slicer, "slicer");
        this.namingStrategy = Preconditions.checkNotNull(namingStrategy, "namingStrategy");
    }

    @Override
    public String execute(String container, Blob blob) {
        String key = blob.getMetadata().getName();
        Payload payload = blob.getPayload();
        Long length = payload.getContentMetadata().getContentLength();
        Preconditions.checkNotNull(length, "please invoke payload.getContentMetadata().setContentLength(length) prior to multipart upload");
        long chunkSize = this.algorithm.calculateChunkSize(length);
        int partCount = this.algorithm.getParts();
        if (partCount > 0) {
            for (Payload part : this.slicer.slice(payload, chunkSize)) {
                int partNum = this.algorithm.getNextPart();
                String partName = this.namingStrategy.getPartName(key, partNum, partCount);
                Blob blobPart = this.blobBuilders.get().name(partName).payload(part).contentDisposition(partName).build();
                this.client.putObject(container, this.blob2Object.apply(blobPart));
            }
            return this.client.putObjectManifest(container, key);
        }
        return this.client.putObject(container, this.blob2Object.apply(blob));
    }
}

