/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class SpringSessionSynchronization
implements TransactionSynchronization,
Ordered {
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private boolean holderActive = true;

    public SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory) {
        this.sessionHolder = sessionHolder;
        this.sessionFactory = sessionFactory;
    }

    private Session getCurrentSession() {
        return this.sessionHolder.getSession();
    }

    public int getOrder() {
        return 900;
    }

    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource(this.sessionFactory);
            this.getCurrentSession().disconnect();
        }
    }

    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource(this.sessionFactory, this.sessionHolder);
        }
    }

    public void flush() {
        try {
            SessionFactoryUtils.logger.debug("Flushing Hibernate Session on explicit request");
            this.getCurrentSession().flush();
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
    }

    public void beforeCommit(boolean readOnly) throws DataAccessException {
        Session session;
        if (!readOnly && !FlushMode.isManualFlushMode((session = this.getCurrentSession()).getFlushMode())) {
            try {
                SessionFactoryUtils.logger.debug("Flushing Hibernate Session on transaction synchronization");
                session.flush();
            }
            catch (HibernateException ex) {
                throw SessionFactoryUtils.convertHibernateAccessException(ex);
            }
        }
    }

    public void beforeCompletion() {
        Session session = this.sessionHolder.getSession();
        if (this.sessionHolder.getPreviousFlushMode() != null) {
            session.setFlushMode(this.sessionHolder.getPreviousFlushMode());
        }
        session.disconnect();
    }

    public void afterCommit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        try {
            if (status != 0) {
                this.sessionHolder.getSession().clear();
            }
        }
        finally {
            this.sessionHolder.setSynchronizedWithTransaction(false);
        }
    }
}

