/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate3.support.AbstractLobType;

public class BlobSerializableType
extends AbstractLobType {
    private static final int OUTPUT_BYTE_ARRAY_INITIAL_SIZE = 1024;

    public BlobSerializableType() {
    }

    protected BlobSerializableType(LobHandler lobHandler, TransactionManager jtaTransactionManager) {
        super(lobHandler, jtaTransactionManager);
    }

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return Serializable.class;
    }

    public boolean isMutable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deepCopy(Object value) throws HibernateException {
        try {
            Object object;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(value);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                oos.close();
                throw throwable;
            }
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            try {
                object = ois.readObject();
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                ois.close();
                throw throwable;
            }
            ois.close();
            return object;
        }
        catch (ClassNotFoundException ex) {
            throw new HibernateException("Couldn't clone BLOB contents", ex);
        }
        catch (IOException ex) {
            throw new HibernateException("Couldn't clone BLOB contents", ex);
        }
    }

    protected Object nullSafeGetInternal(ResultSet rs, String[] names, Object owner, LobHandler lobHandler) throws SQLException, IOException, HibernateException {
        InputStream is = lobHandler.getBlobAsBinaryStream(rs, names[0]);
        if (is != null) {
            Object object;
            ObjectInputStream ois = new ObjectInputStream(is);
            try {
                object = ois.readObject();
                Object var9_9 = null;
            }
            catch (ClassNotFoundException ex) {
                try {
                    throw new HibernateException("Could not deserialize BLOB contents", ex);
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    ois.close();
                    throw throwable;
                }
            }
            ois.close();
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nullSafeSetInternal(PreparedStatement ps, int index, Object value, LobCreator lobCreator) throws SQLException, IOException {
        block3: {
            if (value != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                try {
                    oos.writeObject(value);
                    oos.flush();
                    lobCreator.setBlobAsBytes(ps, index, baos.toByteArray());
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    oos.close();
                    throw throwable;
                }
                oos.close();
                {
                    break block3;
                }
            }
            lobCreator.setBlobAsBytes(ps, index, null);
        }
    }
}

