/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit;

import org.duracloud.audit.task.AuditTask;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.workman.TaskProcessor;
import org.duracloud.mill.workman.TaskProcessorCreationFailedException;
import org.duracloud.mill.workman.TaskProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuditTaskProcessorFactory
implements TaskProcessorFactory {
    private final Logger log = LoggerFactory.getLogger(AuditTaskProcessorFactory.class);

    @Override
    public final TaskProcessor create(Task task) throws TaskProcessorCreationFailedException {
        if (this.isSupported(task)) {
            this.log.debug("creating task processor for " + task);
            AuditTask auditTask = new AuditTask();
            auditTask.readTask(task);
            return this.createImpl(auditTask);
        }
        throw new TaskProcessorCreationFailedException("Task is not an Audit task");
    }

    protected abstract TaskProcessor createImpl(AuditTask var1);

    @Override
    public boolean isSupported(Task task) {
        return task.getType().equals((Object)Task.Type.AUDIT);
    }
}

