/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.bit;

import java.io.InputStream;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.mill.bit.BitIntegrityCheckTask;
import org.duracloud.mill.bit.BitIntegrityCheckTaskExecutionFailedException;
import org.duracloud.mill.bit.BitIntegrityHelper;
import org.duracloud.mill.bit.ChecksumsDoNotMatchException;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentChecksumHelper {
    private static Logger log = LoggerFactory.getLogger(ContentChecksumHelper.class);
    private StorageProviderType storageProviderType;
    private ChecksumUtil checksumUtil;
    private BitIntegrityCheckTask bitTask;
    private StorageProvider store;
    private boolean checked = false;
    private String contentChecksum;

    public ContentChecksumHelper(StorageProviderType storageProviderType, BitIntegrityCheckTask bitTask, StorageProvider store, ChecksumUtil checksumUtil) {
        this.storageProviderType = storageProviderType;
        this.bitTask = bitTask;
        this.store = store;
        this.checksumUtil = checksumUtil;
    }

    public String getContentChecksum(final String correctChecksum) throws TaskExecutionFailedException {
        if (this.checked) {
            return this.contentChecksum;
        }
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public String retry() throws Exception {
                    try (InputStream inputStream = ContentChecksumHelper.this.store.getContent(ContentChecksumHelper.this.bitTask.getSpaceId(), ContentChecksumHelper.this.bitTask.getContentId());){
                        String checksum = ContentChecksumHelper.this.checksumUtil.generateChecksum(inputStream);
                        ContentChecksumHelper.this.contentChecksum = checksum;
                        if (!correctChecksum.equals(checksum)) {
                            throw new ChecksumsDoNotMatchException(BitIntegrityHelper.buildFailureMessage("The content checksum does not match specified checksum: ", ContentChecksumHelper.this.bitTask, ContentChecksumHelper.this.storageProviderType));
                        }
                        log.debug("success - content checksum matches specified checksum: {}", (Object)correctChecksum);
                        String string = checksum;
                        return string;
                    }
                }
            });
        }
        catch (ChecksumsDoNotMatchException | NotFoundException ex) {
            if (ex instanceof NotFoundException) {
                log.warn(BitIntegrityHelper.buildFailureMessage("Could not compute checksum  - content not found", this.bitTask, this.storageProviderType));
            } else {
                log.warn("Checksums did not match provided checksum = {}, content checksum = {}", (Object)correctChecksum, (Object)this.contentChecksum);
            }
        }
        catch (Exception e) {
            throw new BitIntegrityCheckTaskExecutionFailedException(BitIntegrityHelper.buildFailureMessage("Could not compute checksum from content stream", this.bitTask, this.storageProviderType), e);
        }
        this.checked = true;
        return this.contentChecksum;
    }
}

