/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.bit;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.duracloud.common.util.DateUtil;
import org.duracloud.mill.bit.BitIntegrityCheckReportTask;
import org.duracloud.mill.bitlog.BitIntegrityResult;
import org.duracloud.mill.bitlog.BitLogStore;
import org.duracloud.mill.db.model.ManifestItem;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessor;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceComparisonTaskProcessor
implements TaskProcessor {
    private static Logger log = LoggerFactory.getLogger(SpaceComparisonTaskProcessor.class);
    private BitIntegrityCheckReportTask bitTask;
    private BitLogStore bitLogStore;
    private ManifestStore manifestStore;
    private StorageProvider store;
    private StorageProviderType storageProviderType;
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(DateUtil.DateFormat.DEFAULT_FORMAT.getPattern());

    public SpaceComparisonTaskProcessor(BitIntegrityCheckReportTask bitTask, BitLogStore bitLogStore, ManifestStore manifestStore, StorageProvider store, StorageProviderType storageProviderType) {
        this.bitTask = bitTask;
        this.bitLogStore = bitLogStore;
        this.manifestStore = manifestStore;
        this.storageProviderType = storageProviderType;
        this.store = store;
    }

    @Override
    public void execute() throws TaskExecutionFailedException {
        String account = this.bitTask.getAccount();
        String storeId = this.bitTask.getStoreId();
        String spaceId = this.bitTask.getSpaceId();
        log.info("starting space comparison where account={} storeId={} spaceId={}", account, storeId, spaceId);
        try {
            ManifestItem item;
            Iterator<String> it = this.store.getSpaceContents(spaceId, null);
            while (it.hasNext()) {
                String contentId = it.next();
                try {
                    item = this.manifestStore.getItem(account, storeId, spaceId, contentId);
                }
                catch (org.duracloud.error.NotFoundException ex) {
                    item = null;
                }
                if (item != null && !item.isDeleted()) continue;
                Map<String, String> props = this.store.getContentProperties(spaceId, contentId);
                String modified = props.get("content-modified");
                String checksum = props.get("content-checksum");
                Date modifiedDate = null;
                if (modified != null) {
                    modifiedDate = DATE_FORMAT.parse(modified);
                }
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -1);
                Date oneDayAgo = calendar.getTime();
                if (modified != null && !modifiedDate.before(oneDayAgo)) continue;
                this.bitLogStore.write(account, storeId, spaceId, contentId, new Date(), this.storageProviderType, BitIntegrityResult.ERROR, null, checksum, null, "Content item is in the storage provider but not in the manifest and the content is more than a day old.");
            }
            Iterator<ManifestItem> manifestIterator = this.manifestStore.getItems(account, storeId, spaceId);
            while (manifestIterator.hasNext()) {
                item = manifestIterator.next();
                String contentId = item.getContentId();
                try {
                    this.store.getContentProperties(spaceId, contentId);
                    if (!item.isMissingFromStorageProvider()) continue;
                    this.manifestStore.updateMissingFromStorageProviderFlag(account, storeId, spaceId, contentId, false);
                }
                catch (NotFoundException ex) {
                    log.debug("no content found in storage provider for manifest item: {}", (Object)item);
                    if (item.isDeleted()) continue;
                    if (item.isMissingFromStorageProvider()) {
                        this.bitLogStore.write(account, storeId, spaceId, contentId, new Date(), this.storageProviderType, BitIntegrityResult.ERROR, null, null, item.getContentChecksum(), "Content item is in the manifest but not in the storage provider in the course of the last two bit integrity runs.");
                        continue;
                    }
                    this.manifestStore.updateMissingFromStorageProviderFlag(account, storeId, spaceId, contentId, true);
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExecutionFailedException("failed to complete task: " + ex.getMessage(), ex);
        }
    }
}

