/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.bitlog.jpa;

import java.util.Date;
import java.util.Iterator;
import org.duracloud.common.collection.StreamingIterator;
import org.duracloud.mill.bitlog.BitIntegrityResult;
import org.duracloud.mill.bitlog.BitLogItem;
import org.duracloud.mill.bitlog.BitLogStore;
import org.duracloud.mill.bitlog.ItemWriteFailedException;
import org.duracloud.mill.bitlog.jpa.JpaBitLogItem;
import org.duracloud.mill.bitlog.jpa.JpaBitLogItemRepo;
import org.duracloud.mill.db.model.BitIntegrityReport;
import org.duracloud.mill.db.repo.JpaBitIntegrityReportRepo;
import org.duracloud.mill.db.util.JpaIteratorSource;
import org.duracloud.reportdata.bitintegrity.BitIntegrityReportResult;
import org.duracloud.storage.domain.StorageProviderType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="millJpaRepoTransactionManager")
public class JpaBitLogStore
implements BitLogStore {
    private JpaBitLogItemRepo bitLogItemRepo;
    private JpaBitIntegrityReportRepo bitReportRepo;

    public JpaBitLogStore(JpaBitLogItemRepo bitLogItemRepo, JpaBitIntegrityReportRepo bitReportRepo) {
        this.bitLogItemRepo = bitLogItemRepo;
        this.bitReportRepo = bitReportRepo;
    }

    @Override
    public BitLogItem write(String accountId, String storeId, String spaceId, String contentId, Date timestamp, StorageProviderType storeType, BitIntegrityResult result, String contentCheckSum, String storageProviderChecksum, String manifestChecksum, String details) throws ItemWriteFailedException {
        try {
            JpaBitLogItem item = new JpaBitLogItem();
            item.setAccount(accountId);
            item.setStoreId(storeId);
            item.setStorageProviderType(storeType);
            item.setSpaceId(spaceId);
            item.setContentId(contentId);
            item.setContentChecksum(contentCheckSum);
            item.setStorageProviderChecksum(storageProviderChecksum);
            item.setManifestChecksum(manifestChecksum);
            item.setDetails(details);
            item.setResult(result);
            item.setModified(timestamp);
            return this.bitLogItemRepo.saveAndFlush(item);
        }
        catch (Exception ex) {
            throw new ItemWriteFailedException(ex);
        }
    }

    @Override
    public Iterator<BitLogItem> getBitLogItems(final String account, final String storeId, final String spaceId) {
        return new StreamingIterator<BitLogItem>(new JpaIteratorSource<JpaBitLogItemRepo, JpaBitLogItem>(this.bitLogItemRepo){

            @Override
            protected Page<JpaBitLogItem> getNextPage(Pageable pageable, JpaBitLogItemRepo repo) {
                return repo.findByAccountAndStoreIdAndSpaceIdOrderByContentIdAsc(account, storeId, spaceId, pageable);
            }
        });
    }

    @Override
    public void delete(String account, String storeId, String spaceId) {
        this.bitLogItemRepo.deleteByAccountAndStoreIdAndSpaceId(account, storeId, spaceId);
    }

    @Override
    public BitIntegrityReport addReport(String account, String storeId, String spaceId, String reportSpaceId, String reportContentId, BitIntegrityReportResult result, Date completionDate) {
        BitIntegrityReport report = new BitIntegrityReport();
        report.setAccount(account);
        report.setStoreId(storeId);
        report.setSpaceId(spaceId);
        report.setReportSpaceId(reportSpaceId);
        report.setReportContentId(reportContentId);
        report.setCompletionDate(new Date());
        report.setResult(result);
        report.setDisplay(!result.equals((Object)BitIntegrityReportResult.FAILURE));
        return this.bitReportRepo.saveAndFlush(report);
    }
}

