/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.workman;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.duracloud.common.queue.TaskNotFoundException;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessor;
import org.duracloud.mill.workman.TaskProcessorFactory;
import org.duracloud.mill.workman.TaskWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskWorkerImpl
implements TaskWorker {
    private static Logger log = LoggerFactory.getLogger(TaskWorkerImpl.class);
    private static final Timer TIMER = new Timer();
    private TaskProcessorFactory processorFactory;
    private TaskQueue queue;
    private TaskQueue deadLetterQueue;
    private boolean done = false;
    private boolean started = false;
    private TimerTask currentTimerTask;
    private Task task;
    private boolean initialized = false;

    public TaskWorkerImpl(Task task, TaskProcessorFactory processorFactory, TaskQueue queue, TaskQueue deadLetterQueue) {
        if (task == null) {
            throw new IllegalArgumentException("task must be non-null");
        }
        if (queue == null) {
            throw new IllegalArgumentException("queue must be non-null");
        }
        if (deadLetterQueue == null) {
            throw new IllegalArgumentException("deadLetterQueue must be non-null");
        }
        if (processorFactory == null) {
            throw new IllegalArgumentException("processor must be non-null");
        }
        this.task = task;
        this.processorFactory = processorFactory;
        this.queue = queue;
        this.deadLetterQueue = deadLetterQueue;
        log.debug("new worker created {}", (Object)this);
    }

    private void scheduleVisibilityTimeoutExtender(final Task task, Date timeFrom, final Integer visibilityTimeout) {
        TimerTask timerTask;
        Date executionTime = new Date(timeFrom.getTime() + (long)((double)(visibilityTimeout * 1000) * 0.5));
        this.currentTimerTask = timerTask = new TimerTask(){

            @Override
            public void run() {
                if (!TaskWorkerImpl.this.done) {
                    try {
                        log.debug("extending timeout of {} {} seconds", (Object)task, (Object)visibilityTimeout);
                        TaskWorkerImpl.this.queue.extendVisibilityTimeout(task);
                        log.debug("timeout extended for {}", (Object)task);
                        TaskWorkerImpl.this.scheduleVisibilityTimeoutExtender(task, new Date(), visibilityTimeout);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }
            }
        };
        TIMER.schedule(this.currentTimerTask, executionTime);
    }

    protected void init() {
        log.debug("taskworker {} initializing...", (Object)this);
        this.scheduleVisibilityTimeoutExtender(this.task, new Date(), this.task.getVisibilityTimeout());
        log.debug("taskworker {} initialized", (Object)this);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        log.debug("taskworker run starting...", (Object)this);
        if (!this.initialized) {
            String error = "The taskworker must be initialized before it can be run";
            log.error(error);
            throw new RuntimeException(error);
        }
        if (this.done || this.started) {
            log.warn("task worker {} can only be run once:  started={}, done={}. Ignoring...", this, this.started, this.done);
            return;
        }
        this.started = true;
        try {
            log.debug("{} dequeued {}", (Object)this, (Object)this.task);
            TaskProcessor processor = this.processorFactory.create(this.task);
            processor.execute();
            this.queue.deleteTask(this.task);
            log.info("completed task:  task_type={} task_class{} attempts={} result={} elapsed_time={}", new Object[]{this.task.getType(), this.task.getClass().getSimpleName(), this.task.getAttempts(), "success", System.currentTimeMillis() - startTime});
        }
        catch (TaskExecutionFailedException e) {
            int attempts = this.task.getAttempts();
            log.error("failed to complete:  task_type=" + (Object)((Object)this.task.getType()) + " attempts=" + attempts + " result=failure elapsed_time=" + (System.currentTimeMillis() - startTime) + " message=\"" + e.getMessage() + "\"", e);
            if (attempts < 4) {
                this.queue.requeue(this.task);
            } else {
                this.task.addProperty("error", e.getMessage());
                this.sendToDeadLetterQueue(this.task);
            }
        }
        catch (Exception e) {
            log.error("unexpected error: " + e.getMessage(), e);
            e.printStackTrace();
        }
        finally {
            this.done = true;
            if (this.currentTimerTask != null) {
                this.currentTimerTask.cancel();
            }
            log.debug("task worker finished {}", (Object)this.task);
        }
    }

    private void sendToDeadLetterQueue(Task task) {
        log.info("putting {} on dead letter queue", (Object)task);
        try {
            log.debug("deleting {} from {}", (Object)task, (Object)this.queue);
            this.queue.deleteTask(task);
        }
        catch (TaskNotFoundException e) {
            log.error("Error deleting " + task + ". This should never happen: " + e.getMessage(), e);
        }
        this.deadLetterQueue.put(task);
        log.info("sent {} to dead-letter-queue={}", (Object)task, (Object)this.deadLetterQueue.getName());
    }
}

