/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.bit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.DateUtil;
import org.duracloud.mill.bit.BitIntegrityCheckReportTask;
import org.duracloud.mill.bit.BitIntegrityHelper;
import org.duracloud.mill.bitlog.BitIntegrityResult;
import org.duracloud.mill.bitlog.BitLogItem;
import org.duracloud.mill.bitlog.BitLogStore;
import org.duracloud.mill.db.model.BitIntegrityReport;
import org.duracloud.mill.notification.NotificationManager;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessorBase;
import org.duracloud.mill.workman.spring.WorkmanConfigurationManager;
import org.duracloud.reportdata.bitintegrity.BitIntegrityReportResult;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitIntegrityReportTaskProcessor
extends TaskProcessorBase {
    private static Logger log = LoggerFactory.getLogger(BitIntegrityReportTaskProcessor.class);
    private BitIntegrityCheckReportTask task;
    private BitLogStore bitLogStore;
    private StorageProvider store;
    private WorkmanConfigurationManager config;
    private NotificationManager notificationManager;

    public BitIntegrityReportTaskProcessor(BitIntegrityCheckReportTask task, BitLogStore bitLogStore, StorageProvider store, WorkmanConfigurationManager config, NotificationManager notificationManager) {
        super(task);
        this.task = task;
        this.bitLogStore = bitLogStore;
        this.store = store;
        this.config = config;
        this.notificationManager = notificationManager;
    }

    @Override
    protected void executeImpl() throws TaskExecutionFailedException {
        String account = this.task.getAccount();
        String storeId = this.task.getStoreId();
        String spaceId = this.task.getSpaceId();
        File bitLogDir = new File(this.config.getWorkDirectoryPath() + File.separator + "bit-integrity-reports");
        if (!bitLogDir.exists()) {
            bitLogDir.mkdirs();
        }
        final File bitLog = this.createNewLogFile(account, storeId, spaceId, bitLogDir);
        try {
            List<BitLogItem> errors = this.writeLog(bitLog, account, storeId, spaceId);
            ChecksumUtil util = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
            final String checksum = util.generateChecksum(bitLog);
            String reportSpaceId = "x-duracloud-admin";
            final String reportContentId = "bit-integrity/" + spaceId + "/" + storeId + "/" + bitLog.getName();
            new Retrier().execute(new Retriable(){

                @Override
                public Object retry() throws Exception {
                    return BitIntegrityReportTaskProcessor.this.store.addContent("x-duracloud-admin", reportContentId, "text/tsv", null, bitLog.length(), checksum, new FileInputStream(bitLog));
                }
            });
            BitIntegrityReportResult result = BitIntegrityReportResult.SUCCESS;
            if (errors.size() > 0) {
                result = BitIntegrityReportResult.FAILURE;
            }
            BitIntegrityReport report = this.bitLogStore.addReport(account, storeId, spaceId, "x-duracloud-admin", reportContentId, result, new Date());
            if (errors.size() > 0) {
                log.warn("Bit integirty errors: subdomain: {}, storeId: {}, spaceId: {}: ", account, storeId, spaceId);
                this.notifyManagerOfBitIntegrityErrors(report, errors);
            }
            this.bitLogStore.delete(account, storeId, spaceId);
            bitLog.delete();
        }
        catch (Exception ex) {
            throw new TaskExecutionFailedException("task processing failed: " + ex.getMessage(), ex);
        }
    }

    private void notifyManagerOfBitIntegrityErrors(BitIntegrityReport report, List<BitLogItem> errors) {
        String account = report.getAccount();
        String storeId = report.getStoreId();
        String spaceId = report.getSpaceId();
        String host = account + ".duracloud.org";
        String subject = "Bit Integrity Report #" + report.getId() + ": errors (count = " + errors.size() + ")  detected on " + host + ", providerId=" + storeId + ", spaceId=" + spaceId;
        StringBuilder body = new StringBuilder();
        body.append(BitIntegrityHelper.getHeader());
        for (BitLogItem error : errors) {
            body.append(BitIntegrityHelper.formatLogLine(error) + "\n");
        }
        this.notificationManager.sendEmail(subject, body.toString());
    }

    private List<BitLogItem> writeLog(File bitLog, String account, String storeId, String spaceId) throws Exception {
        LinkedList<BitLogItem> errors = new LinkedList<BitLogItem>();
        try (FileWriter writer = new FileWriter(bitLog);){
            writer.write(BitIntegrityHelper.getHeader());
            Iterator<BitLogItem> it = this.bitLogStore.getBitLogItems(account, storeId, spaceId);
            while (it.hasNext()) {
                BitLogItem item = it.next();
                if (this.isError(item)) {
                    errors.add(item);
                }
                writer.write(BitIntegrityHelper.formatLogLine(item));
                if (!it.hasNext()) continue;
                writer.write("\n");
            }
        }
        return errors;
    }

    private boolean isError(BitLogItem item) {
        BitIntegrityResult result = item.getResult();
        return result.equals((Object)BitIntegrityResult.ERROR) || result.equals((Object)BitIntegrityResult.FAILURE);
    }

    private File createNewLogFile(String account, String storeId, String spaceId, File bitLogDir) {
        SimpleDateFormat fileDateFormat = new SimpleDateFormat(DateUtil.DateFormat.PLAIN_FORMAT.getPattern());
        File bitLog = new File(bitLogDir, "bit-integrity_" + account + "_" + storeId + "_" + spaceId + "_" + fileDateFormat.format(new Date()) + ".tsv");
        return bitLog;
    }
}

