/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task;

import com.amazonaws.services.s3.AmazonS3Client;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3task.NoopTaskRunner;
import org.duracloud.s3task.storage.SetReducedStorageTaskRunner;
import org.duracloud.s3task.storage.SetStandardStorageTaskRunner;
import org.duracloud.s3task.streaming.DeleteStreamingTaskRunner;
import org.duracloud.s3task.streaming.DisableStreamingTaskRunner;
import org.duracloud.s3task.streaming.EnableStreamingTaskRunner;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskProviderBase;
import org.jets3t.service.CloudFrontService;
import org.slf4j.LoggerFactory;

public class S3TaskProvider
extends TaskProviderBase {
    public S3TaskProvider(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonS3Client s3Client, CloudFrontService cfService) {
        this.log = LoggerFactory.getLogger(S3TaskProvider.class);
        this.taskList.add(new NoopTaskRunner());
        this.taskList.add(new EnableStreamingTaskRunner(s3Provider, unwrappedS3Provider, s3Client, cfService));
        this.taskList.add(new DisableStreamingTaskRunner(s3Provider, unwrappedS3Provider, s3Client, cfService));
        this.taskList.add(new DeleteStreamingTaskRunner(s3Provider, unwrappedS3Provider, s3Client, cfService));
        this.taskList.add(new SetStandardStorageTaskRunner(s3Provider, unwrappedS3Provider, s3Client));
        this.taskList.add(new SetReducedStorageTaskRunner(s3Provider, unwrappedS3Provider, s3Client));
    }
}

