/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class DefaultCrudMethods
implements CrudMethods {
    private static final String FIND_ONE = "findOne";
    private static final String SAVE = "save";
    private static final String FIND_ALL = "findAll";
    private static final String DELETE = "delete";
    private final Method findAllMethod;
    private final Method findOneMethod;
    private final Method saveMethod;
    private final Method deleteMethod;

    public DefaultCrudMethods(RepositoryMetadata metadata) {
        Assert.notNull(metadata, "RepositoryInformation must not be null!");
        this.findOneMethod = this.selectMostSuitableFindOneMethod(metadata);
        this.findAllMethod = this.selectMostSuitableFindAllMethod(metadata);
        this.deleteMethod = this.selectMostSuitableDeleteMethod(metadata);
        this.saveMethod = this.selectMostSuitableSaveMethod(metadata);
    }

    private Method selectMostSuitableSaveMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(metadata.getDomainType(), Object.class)) {
            Method saveMethodCandidate = ReflectionUtils.findMethod(metadata.getRepositoryInterface(), SAVE, type);
            if (saveMethodCandidate == null) continue;
            return ClassUtils.getMostSpecificMethod(saveMethodCandidate, metadata.getRepositoryInterface());
        }
        return null;
    }

    private Method selectMostSuitableDeleteMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(metadata.getIdType(), Serializable.class, Iterable.class)) {
            Method candidate = ReflectionUtils.findMethod(metadata.getRepositoryInterface(), DELETE, type);
            if (candidate == null) continue;
            return ClassUtils.getMostSpecificMethod(candidate, metadata.getRepositoryInterface());
        }
        return null;
    }

    private Method selectMostSuitableFindAllMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(Pageable.class, Sort.class)) {
            Method candidate;
            if (!ClassUtils.hasMethod(metadata.getRepositoryInterface(), FIND_ALL, type) || (candidate = ReflectionUtils.findMethod(PagingAndSortingRepository.class, FIND_ALL, type)) == null) continue;
            return ClassUtils.getMostSpecificMethod(candidate, metadata.getRepositoryInterface());
        }
        if (ClassUtils.hasMethod(metadata.getRepositoryInterface(), FIND_ALL, new Class[0])) {
            return ClassUtils.getMostSpecificMethod(ReflectionUtils.findMethod(CrudRepository.class, FIND_ALL), metadata.getRepositoryInterface());
        }
        return null;
    }

    private Method selectMostSuitableFindOneMethod(RepositoryMetadata metadata) {
        for (Class type : Arrays.asList(metadata.getIdType(), Serializable.class)) {
            Method candidate = ReflectionUtils.findMethod(metadata.getRepositoryInterface(), FIND_ONE, type);
            if (candidate == null) continue;
            return ClassUtils.getMostSpecificMethod(candidate, metadata.getRepositoryInterface());
        }
        return null;
    }

    @Override
    public Method getSaveMethod() {
        return this.saveMethod;
    }

    @Override
    public boolean hasSaveMethod() {
        return this.saveMethod != null;
    }

    @Override
    public Method getFindAllMethod() {
        return this.findAllMethod;
    }

    @Override
    public boolean hasFindAllMethod() {
        return this.findAllMethod != null;
    }

    @Override
    public Method getFindOneMethod() {
        return this.findOneMethod;
    }

    @Override
    public boolean hasFindOneMethod() {
        return this.findOneMethod != null;
    }

    @Override
    public boolean hasDelete() {
        return this.deleteMethod != null;
    }

    @Override
    public Method getDeleteMethod() {
        return this.deleteMethod;
    }
}

